<?php namespace CodeIgniter\API;

/**
 * CodeIgniter
 *
 * An open source application development framework for PHP
 *
 * This content is released under the MIT License (MIT)
 *
 * Copyright (c) 2014 - 2017, British Columbia Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package	CodeIgniter
 * @author	CodeIgniter Dev Team
 * @copyright	Copyright (c) 2014 - 2017, British Columbia Institute of Technology (http://bcit.ca/)
 * @license	https://opensource.org/licenses/MIT	MIT License
 * @link	https://codeigniter.com
 * @since	Version 3.0.0
 * @filesource
 */

class JSONFormatter implements FormatterInterface
{
	/**
	 * The error strings to use if encoding hits an error.
	 *
	 * @var array
	 */
	protected $errors = [
		JSON_ERROR_NONE           => 'No error has occurred',
		JSON_ERROR_DEPTH          => 'The maximum stack depth has been exceeded',
		JSON_ERROR_STATE_MISMATCH => 'Invalid or malformed JSON',
		JSON_ERROR_CTRL_CHAR      => 'Control character error, possibly incorrectly encoded',
		JSON_ERROR_SYNTAX         => 'Syntax error',
		JSON_ERROR_UTF8           => 'Malformed UTF-8 characters, possibly incorrectly encoded',
	];

	//--------------------------------------------------------------------

	/**
	 * Takes the given data and formats it.
	 *
	 * @param $data
	 *
	 * @return mixed
	 */
	public function format(array $data)
	{
		$options = ENVIRONMENT == 'production'
			? JSON_NUMERIC_CHECK
			: JSON_NUMERIC_CHECK | JSON_PRETTY_PRINT;

		$result = json_encode($data, 512, $options);

		// If result is NULL, then an error happened.
		// Let them know.
		if ($result === null)
		{
			throw new \RuntimeException($this->errors[json_last_error()]);
		}

		return utf8_encode($result);
	}

	//--------------------------------------------------------------------
}
