<?php namespace Pratik\Controllers;

use CodeIgniter\Controller;
use Pratik\Config\Users_Config;
use Pratik\Models\Pratik_Model;

class Users extends Controller
{
	public $data = array();
	public $model ;
	public $state=false ;
    function __construct()
	{
        $this->model = new Pratik_Model();
        $this->session = \Config\Services::session();
		$this->request = \Config\Services::request();
    }
	public function index()
	{	
		if($this->state === false ) $this->state =  $this->request->getPostget('state');	
		if($this->state===null) $this->state=1;
		$elements = new Users_Config();
		$this->data['page_title']=t_('Users','usersate_'.$this->state);		
		$this->data['elements'] = $elements->basic;	
		$this->data['state'] = $this->state;
		$this->data['menu'] =array('Users','usersate_'.$this->state);		
		return view('Admin\users\users_list', array('data'=>$this->data));
	}
	public function setup()
	{
		$elements = new Users_Config();
		$this->model->setupTable('users',$elements->basic);
		$this->data['menu']=array('users');
	}
	public function edit()
	{	
		$id =  $this->request->getPostget('id');
		$elements = new Users_Config();
		//$model->setupTable('users',$elements->basic);
		$this->data['basic'] = $this->model->getBasic('users', $id, $elements->basic,'',true );
		if($id==0)
		{
			$this->data['basic']['id']['val']=0;
			$this->data['basic']['name']['val']=t_('Yeni Kullanıcı');
			
		}
		$this->data['metas'] = $this->model->getMetas($id, 'users', "",$elements->metas, 'tr_TR', 'meta', true, false);
		$this->data['page_title']=t_('Users');		
		$this->data['menu']=array('users','user_edit');
		return view('Admin\users\user_edit', array('data'=>$this->data));
	}

	public function delete()
	{	
		$id =  $this->request->getPostget('id');
		$this->state = 0;
		
		if(!$id)
		{
			addAlert('Code', t_('Geçersiz Kayıt Id!'), 'danger' );				
		} elseif($id==UID()){
			addAlert('Code', t_('Kendinizi Silemezsiniz!'), 'danger' );			
			$this->state = 1;
		} else {
			$this->model->setTableValue('users', $id, 'state', '0');
			addAlert('Code', t_('Kayıt Silindi!'), 'success' );
			
		}
		return $this->index();
		
	}

	public function confirm()
	{	
		$id =  $this->request->getPostget('id');
		if($id)
		{

			$this->model->setTableValue('users', $id, 'state', '1');
			addAlert('Code', t_('Kayıt Onaylandı!'), 'success' );
			
		} else {
			
			addAlert('Code', t_('Geçersiz id!'), 'danger' );
		}
		$this->state = 1;
		return $this->index();
		
	}	
	//--------------------------------------------------------------------

}
