<?php namespace Pratik\Controllers;
use CodeIgniter\Controller;
use Pratik\Models\Pratik_Model;
class Setup extends Controller
{
	public $data = array();
	public $model = array();
    function __construct()
	{
        $this->model = new Pratik_Model();
        $this->session = \Config\Services::session();
		$this->request = \Config\Services::request();
    }
	public function index()
	{
		die('/module?module= '.' or '.'/table?table=');
	}
	public function module()
	{	
		$module =  $this->request->getPostget('module');
		$config =  $this->request->getPostget('config');
		if(!$config) $config = 'basic';
		if($module)
		{
			$module = strtolower($module);
			$config = strtolower($config);
			$module_path = "\Pratik\Config\\".ucfirst($module)."_Config";
			$elements =  new $module_path();
			$this->model->setupModule($module,$elements->$config);
		}
		$this->data['page_title']='Kurulum';
		$this->data['menu']=array('setup');
		return view('Admin\setup\setup', array('data'=>$this->data));
	}
	public function table()
	{	
		$module =  $this->request->getPostget('module');
		$config =  $this->request->getPostget('config');
		if(!$config) $config = 'basic';
		if($module)
		{
			$module = strtolower($module);
			$config = strtolower($config);
			$module_path = "\Pratik\Config\\".ucfirst($module)."_Config";
			$elements =  new $module_path();
			$this->model->setupTable($module.'_'.$config,$elements->$config);
		}
		$this->data['page_title']='Kurulum';
		$this->data['menu']=array('setup');
		return view('Admin\setup\setup', array('data'=>$this->data));
	}
	public function deletetable()
	{	
		$module =  $this->request->getPostget('module');
		$this->model->deleteTable(strtolower($module));
	}
	public function emptytable()
	{	
		$module =  $this->request->getPostget('module');
		$this->model->emptyTable(strtolower($module));
	}
	public function data()
	{
		$module =  $this->request->getPostget('module');
		if($module)
		{
			$function = 'sql_'.$module;
			if( method_exists($this, $function))
			{
				$sqls = $this->$function();
				$this->model->runSqls($sqls);
				$rows = $this->model->getTableRows($module);
				print_r($rows);
			}
		}
	}
	
	public function sql_cities()
	{
		$sqls[] = "CREATE TABLE IF NOT EXISTS `".DBPREFIX."cities` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `state` tinyint(1) NOT NULL,
		  `group` varchar(32) NOT NULL,
		  `parent` decimal(10,2) NOT NULL,
		  `sort` int(11) NOT NULL,
		  `code` varchar(4) NOT NULL,
		  `name` varchar(64) NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=132 ;";
			
		$sqls[] = "INSERT INTO `".DBPREFIX."cities` (`id`, `state`, `group`, `parent`, `sort`, `code`, `name`) VALUES
		(52, 1, ' ', '0.00', 0, '1', 'Adana'),
		(53, 1, ' ', '0.00', 0, '2', 'Adıyaman'),
		(54, 1, ' ', '0.00', 0, '3', 'Afyonkarahisar'),
		(55, 1, ' ', '0.00', 0, '4', 'Ağrı'),
		(56, 1, ' ', '0.00', 0, '5', 'Amasya'),
		(57, 1, ' ', '0.00', 0, '6', 'Ankara'),
		(58, 1, ' ', '0.00', 0, '7', 'Antalya'),
		(59, 1, ' ', '0.00', 0, '8', 'Artvin'),
		(60, 1, ' ', '0.00', 0, '9', 'Aydın'),
		(61, 1, ' ', '0.00', 0, '10', 'Balıkesir'),
		(62, 1, ' ', '0.00', 0, '11', 'Bilecik'),
		(63, 1, ' ', '0.00', 0, '12', 'Bingöl'),
		(64, 1, ' ', '0.00', 0, '13', 'Bitlis'),
		(65, 1, ' ', '0.00', 0, '14', 'Bolu'),
		(66, 1, ' ', '0.00', 0, '15', 'Burdur'),
		(67, 1, ' ', '0.00', 0, '16', 'Bursa'),
		(68, 1, ' ', '0.00', 0, '17', 'Çanakkale'),
		(69, 1, ' ', '0.00', 0, '18', 'Çankırı'),
		(70, 1, ' ', '0.00', 0, '19', 'Çorum'),
		(71, 1, ' ', '0.00', 0, '20', 'Denizli'),
		(72, 1, ' ', '0.00', 0, '21', 'Diyarbakır'),
		(73, 1, ' ', '0.00', 0, '22', 'Edirne'),
		(74, 1, ' ', '0.00', 0, '23', 'Elazığ'),
		(75, 1, ' ', '0.00', 0, '24', 'Erzincan'),
		(76, 1, ' ', '0.00', 0, '25', 'Erzurum'),
		(77, 1, ' ', '0.00', 0, '26', 'Eskişehir'),
		(78, 1, ' ', '0.00', 0, '27', 'Gaziantep'),
		(79, 1, ' ', '0.00', 0, '28', 'Giresun'),
		(80, 1, ' ', '0.00', 0, '29', 'Gümüşhane'),
		(81, 1, ' ', '0.00', 0, '30', 'Hakkari'),
		(82, 1, ' ', '0.00', 0, '31', 'Hatay'),
		(83, 1, ' ', '0.00', 0, '32', 'Isparta'),
		(84, 1, ' ', '0.00', 0, '33', 'Mersin'),
		(85, 1, ' ', '0.00', 0, '34', 'İstanbul'),
		(86, 1, ' ', '0.00', 0, '35', 'İzmir'),
		(87, 1, ' ', '0.00', 0, '36', 'Kars'),
		(88, 1, ' ', '0.00', 0, '37', 'Kastamonu'),
		(89, 1, ' ', '0.00', 0, '38', 'Kayseri'),
		(90, 1, ' ', '0.00', 0, '39', 'Kırklareli'),
		(91, 1, ' ', '0.00', 0, '40', 'Kırşehir'),
		(92, 1, ' ', '0.00', 0, '41', 'Kocaeli'),
		(93, 1, ' ', '0.00', 0, '42', 'Konya'),
		(94, 1, ' ', '0.00', 0, '43', 'Kütahya'),
		(95, 1, ' ', '0.00', 0, '44', 'Malatya'),
		(96, 1, ' ', '0.00', 0, '45', 'Manisa'),
		(97, 1, ' ', '0.00', 0, '46', 'Kahramanmaraş'),
		(98, 1, ' ', '0.00', 0, '47', 'Mardin'),
		(99, 1, ' ', '0.00', 0, '48', 'Muğla'),
		(100, 1, ' ', '0.00', 0, '49', 'Muş'),
		(101, 1, ' ', '0.00', 0, '50', 'Nevşehir'),
		(102, 1, ' ', '0.00', 0, '51', 'Niğde'),
		(103, 1, ' ', '0.00', 0, '52', 'Ordu'),
		(104, 1, ' ', '0.00', 0, '53', 'Rize'),
		(105, 1, ' ', '0.00', 0, '54', 'Sakarya'),
		(106, 1, ' ', '0.00', 0, '55', 'Samsun'),
		(107, 1, ' ', '0.00', 0, '56', 'Siirt'),
		(108, 1, ' ', '0.00', 0, '57', 'Sinop'),
		(109, 1, ' ', '0.00', 0, '58', 'Sivas'),
		(110, 1, ' ', '0.00', 0, '59', 'Tekirdağ'),
		(111, 1, ' ', '0.00', 0, '60', 'Tokat'),
		(112, 1, ' ', '0.00', 0, '61', 'Trabzon'),
		(113, 1, ' ', '0.00', 0, '62', 'Tunceli'),
		(114, 1, ' ', '0.00', 0, '63', 'Şanlıurfa'),
		(115, 1, ' ', '0.00', 0, '64', 'Uşak'),
		(116, 1, ' ', '0.00', 0, '65', 'Van'),
		(117, 1, ' ', '0.00', 0, '66', 'Yozgat'),
		(118, 1, ' ', '0.00', 0, '67', 'Zonguldak'),
		(119, 1, ' ', '0.00', 0, '68', 'Aksaray'),
		(120, 1, ' ', '0.00', 0, '69', 'Bayburt'),
		(121, 1, ' ', '0.00', 0, '70', 'Karaman'),
		(122, 1, ' ', '0.00', 0, '71', 'Kırıkkale'),
		(123, 1, ' ', '0.00', 0, '72', 'Batman'),
		(124, 1, ' ', '0.00', 0, '73', 'Şırnak'),
		(125, 1, ' ', '0.00', 0, '74', 'Bartın'),
		(126, 1, ' ', '0.00', 0, '75', 'Ardahan'),
		(127, 1, ' ', '0.00', 0, '76', 'Iğdır'),
		(128, 1, ' ', '0.00', 0, '77', 'Yalova'),
		(129, 1, ' ', '0.00', 0, '78', 'Karabük'),
		(130, 1, ' ', '0.00', 0, '79', 'Kilis'),
		(131, 1, ' ', '0.00', 0, '81', 'Düzce');";
		return $sqls;
	}
	public function sql_districts()
	{
		$sqls[]="CREATE TABLE `".DBPREFIX."districts` (
		  `id` int(11) NOT NULL,
		  `state` tinyint(1) NOT NULL,
		  `group` varchar(32) NOT NULL,
		  `parent` int(11) NOT NULL,
		  `sort` int(11) NOT NULL,
		  `code` varchar(8) NOT NULL,
		  `name` varchar(64) NOT NULL
		) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
		$sqls[]="INSERT INTO `".DBPREFIX."districts` (`id`, `state`, `group`, `parent`, `sort`, `code`, `name`) VALUES
(1, 1, 'ilce', 60, 0, '0', 'Efeler'),
(2, 1, 'ilce', 60, 0, '0', 'Bozdoğan'),
(3, 1, 'ilce', 60, 0, '0', 'Buharkent'),
(4, 1, 'ilce', 60, 0, '0', 'Çine'),
(5, 1, 'ilce', 60, 0, '0', 'Didim'),
(6, 1, 'ilce', 60, 0, '0', 'Germencik'),
(7, 1, 'ilce', 60, 0, '0', 'İncirliova'),
(8, 1, 'ilce', 60, 0, '0', 'Karacasu'),
(9, 1, 'ilce', 60, 0, '0', 'Karpuzlu'),
(10, 1, 'ilce', 60, 0, '0', 'Koçarlı'),
(11, 1, 'ilce', 60, 0, '0', 'Köşk'),
(12, 1, 'ilce', 60, 0, '0', 'Kuşadası'),
(13, 1, 'ilce', 60, 0, '0', 'Kuyucak'),
(14, 1, 'ilce', 60, 0, '0', 'Nazilli'),
(15, 1, 'ilce', 60, 0, '0', 'Söke'),
(16, 1, 'ilce', 60, 0, '0', 'Sultanhisar'),
(17, 1, 'ilce', 60, 0, '0', 'Yenipazar'),
(18, 1, 'ilce', 66, 0, '0', 'Merkez'),
(19, 1, 'ilce', 66, 0, '0', 'Ağlasun'),
(20, 1, 'ilce', 66, 0, '0', 'Altınyayla'),
(21, 1, 'ilce', 66, 0, '0', 'Bucak'),
(22, 1, 'ilce', 66, 0, '0', 'Çavdır'),
(23, 1, 'ilce', 66, 0, '0', 'Çeltikçi'),
(24, 1, 'ilce', 66, 0, '0', 'Gölhisar'),
(25, 1, 'ilce', 66, 0, '0', 'Karamanlı'),
(26, 1, 'ilce', 66, 0, '0', 'Kemer'),
(27, 1, 'ilce', 66, 0, '0', 'Tefenni'),
(28, 1, 'ilce', 66, 0, '0', 'Yeşilova'),
(29, 1, 'ilce', 83, 0, '0', 'Merkez'),
(30, 1, 'ilce', 83, 0, '0', 'Aksu'),
(31, 1, 'ilce', 83, 0, '0', 'Atabey'),
(32, 1, 'ilce', 83, 0, '0', 'Eğirdir'),
(33, 1, 'ilce', 83, 0, '0', 'Gelendost'),
(34, 1, 'ilce', 83, 0, '0', 'Gönen'),
(35, 1, 'ilce', 83, 0, '0', 'Keçiborlu'),
(36, 1, 'ilce', 83, 0, '0', 'Senirkent'),
(37, 1, 'ilce', 83, 0, '0', 'Sütçüler'),
(38, 1, 'ilce', 83, 0, '0', 'Şarkikaraağaç'),
(39, 1, 'ilce', 83, 0, '0', 'Uluborlu'),
(40, 1, 'ilce', 83, 0, '0', 'Yalvaç'),
(41, 1, 'ilce', 83, 0, '0', 'Yenişarbademli'),
(42, 1, 'ilce', 52, 0, '0', 'Aladağ'),
(43, 1, 'ilce', 52, 0, '0', 'Ceyhan'),
(44, 1, 'ilce', 52, 0, '0', 'Çukurova'),
(45, 1, 'ilce', 52, 0, '0', 'Feke'),
(46, 1, 'ilce', 52, 0, '0', 'İmamoğlu'),
(47, 1, 'ilce', 52, 0, '0', 'Karaisalı'),
(48, 1, 'ilce', 52, 0, '0', 'Karataş'),
(49, 1, 'ilce', 52, 0, '0', 'Kozan'),
(50, 1, 'ilce', 52, 0, '0', 'Pozantı'),
(51, 1, 'ilce', 52, 0, '0', 'Saimbeyli'),
(52, 1, 'ilce', 52, 0, '0', 'Sarıçam'),
(53, 1, 'ilce', 52, 0, '0', 'Seyhan'),
(54, 1, 'ilce', 52, 0, '0', 'Tufanbeyli'),
(55, 1, 'ilce', 52, 0, '0', 'Yumurtalık'),
(56, 1, 'ilce', 52, 0, '0', 'Yüreğir'),
(57, 1, 'ilce', 53, 0, '0', 'Besni'),
(58, 1, 'ilce', 53, 0, '0', 'Çelikhan'),
(59, 1, 'ilce', 53, 0, '0', 'Gerger'),
(60, 1, 'ilce', 53, 0, '0', 'Gölbaşı'),
(61, 1, 'ilce', 53, 0, '0', 'Kahta'),
(62, 1, 'ilce', 53, 0, '0', 'Samsat'),
(63, 1, 'ilce', 53, 0, '0', 'Sincik'),
(64, 1, 'ilce', 53, 0, '0', 'Tut'),
(65, 1, 'ilce', 54, 0, '0', 'Basmakçı'),
(66, 1, 'ilce', 54, 0, '0', 'Bayat'),
(67, 1, 'ilce', 54, 0, '0', 'Bolvadin'),
(68, 1, 'ilce', 54, 0, '0', 'Çay'),
(69, 1, 'ilce', 54, 0, '0', 'Çobanlar'),
(70, 1, 'ilce', 54, 0, '0', 'Dazkırı'),
(71, 1, 'ilce', 54, 0, '0', 'Dinar'),
(72, 1, 'ilce', 54, 0, '0', 'Emirdağ'),
(73, 1, 'ilce', 54, 0, '0', 'Evciler'),
(74, 1, 'ilce', 54, 0, '0', 'Hocalar'),
(75, 1, 'ilce', 54, 0, '0', 'İhsaniye'),
(76, 1, 'ilce', 54, 0, '0', 'İscehisar'),
(77, 1, 'ilce', 54, 0, '0', 'Kızılören'),
(78, 1, 'ilce', 54, 0, '0', 'Sandıklı'),
(79, 1, 'ilce', 54, 0, '0', 'Sinanpaşa'),
(80, 1, 'ilce', 54, 0, '0', 'Sultandağı'),
(81, 1, 'ilce', 54, 0, '0', 'Şuhut'),
(82, 1, 'ilce', 55, 0, '0', 'Diyadin'),
(83, 1, 'ilce', 55, 0, '0', 'Doğubeyazıt'),
(84, 1, 'ilce', 55, 0, '0', 'Eleşkirt'),
(85, 1, 'ilce', 55, 0, '0', 'Hamur'),
(86, 1, 'ilce', 55, 0, '0', 'Patnos'),
(87, 1, 'ilce', 55, 0, '0', 'Taşlıçay'),
(88, 1, 'ilce', 55, 0, '0', 'Tutak'),
(89, 1, 'ilce', 56, 0, '0', 'Göynücek'),
(90, 1, 'ilce', 56, 0, '0', 'Gümüşhacıköy'),
(91, 1, 'ilce', 56, 0, '0', 'Hamamözü'),
(92, 1, 'ilce', 56, 0, '0', 'Merzifon'),
(93, 1, 'ilce', 56, 0, '0', 'Suluova'),
(94, 1, 'ilce', 56, 0, '0', 'Taşova'),
(95, 1, 'ilce', 57, 0, '0', 'Akyurt'),
(96, 1, 'ilce', 57, 0, '0', 'Altındağ'),
(97, 1, 'ilce', 57, 0, '0', 'Ayaş'),
(98, 1, 'ilce', 57, 0, '0', 'Bala'),
(99, 1, 'ilce', 57, 0, '0', 'Beypazarı'),
(100, 1, 'ilce', 57, 0, '0', 'Çamlıdere'),
(101, 1, 'ilce', 57, 0, '0', 'Çankaya'),
(102, 1, 'ilce', 57, 0, '0', 'Çubuk'),
(103, 1, 'ilce', 57, 0, '0', 'Elmadağ'),
(104, 1, 'ilce', 57, 0, '0', 'Etimesgut'),
(105, 1, 'ilce', 57, 0, '0', 'Evren'),
(106, 1, 'ilce', 57, 0, '0', 'Gölbaşı'),
(107, 1, 'ilce', 57, 0, '0', 'Güdül'),
(108, 1, 'ilce', 57, 0, '0', 'Haymana'),
(109, 1, 'ilce', 57, 0, '0', 'Kalecik'),
(110, 1, 'ilce', 57, 0, '0', 'Kazan'),
(111, 1, 'ilce', 57, 0, '0', 'Keçiören'),
(112, 1, 'ilce', 57, 0, '0', 'Kızılcahamam'),
(113, 1, 'ilce', 57, 0, '0', 'Mamak'),
(114, 1, 'ilce', 57, 0, '0', 'Nallıhan'),
(115, 1, 'ilce', 57, 0, '0', 'Polatlı'),
(116, 1, 'ilce', 57, 0, '0', 'Pursaklar'),
(117, 1, 'ilce', 57, 0, '0', 'Sincan'),
(118, 1, 'ilce', 57, 0, '0', 'Şereflikoçhisar'),
(119, 1, 'ilce', 57, 0, '0', 'Yenimahalle'),
(120, 1, 'ilce', 58, 0, '0', 'Akseki'),
(121, 1, 'ilce', 58, 0, '0', 'Aksu'),
(122, 1, 'ilce', 58, 0, '0', 'Alanya'),
(123, 1, 'ilce', 58, 0, '0', 'Demre'),
(124, 1, 'ilce', 58, 0, '0', 'Döşemealtı'),
(125, 1, 'ilce', 58, 0, '0', 'Elmalı'),
(126, 1, 'ilce', 58, 0, '0', 'Finike'),
(127, 1, 'ilce', 58, 0, '0', 'Gazipaşa'),
(128, 1, 'ilce', 58, 0, '0', 'Gündoğmuş'),
(129, 1, 'ilce', 58, 0, '0', 'İbradi'),
(130, 1, 'ilce', 58, 0, '0', 'Kaş'),
(131, 1, 'ilce', 58, 0, '0', 'Kemer'),
(132, 1, 'ilce', 58, 0, '0', 'Kepez'),
(133, 1, 'ilce', 58, 0, '0', 'Konyaaltı'),
(134, 1, 'ilce', 58, 0, '0', 'Korkuteli'),
(135, 1, 'ilce', 58, 0, '0', 'Kumluca'),
(136, 1, 'ilce', 58, 0, '0', 'Manavgat'),
(137, 1, 'ilce', 58, 0, '0', 'Muratpaşa'),
(138, 1, 'ilce', 58, 0, '0', 'Serik'),
(139, 1, 'ilce', 59, 0, '0', 'Ardanuç'),
(140, 1, 'ilce', 59, 0, '0', 'Arhavi'),
(141, 1, 'ilce', 59, 0, '0', 'Borçka'),
(142, 1, 'ilce', 59, 0, '0', 'Hopa'),
(143, 1, 'ilce', 59, 0, '0', 'Murgul'),
(144, 1, 'ilce', 59, 0, '0', 'Şavşat'),
(145, 1, 'ilce', 59, 0, '0', 'Yusufeli'),
(146, 1, 'ilce', 61, 0, '0', 'Ayvalık'),
(147, 1, 'ilce', 61, 0, '0', 'Balya'),
(148, 1, 'ilce', 61, 0, '0', 'Bandırma'),
(149, 1, 'ilce', 61, 0, '0', 'Bigadiç'),
(150, 1, 'ilce', 61, 0, '0', 'Burhaniye'),
(151, 1, 'ilce', 61, 0, '0', 'Dursunbey'),
(152, 1, 'ilce', 61, 0, '0', 'Edremit'),
(153, 1, 'ilce', 61, 0, '0', 'Erdek'),
(154, 1, 'ilce', 61, 0, '0', 'Gömeç'),
(155, 1, 'ilce', 61, 0, '0', 'Gönen'),
(156, 1, 'ilce', 61, 0, '0', 'Havran'),
(157, 1, 'ilce', 61, 0, '0', 'İvrindi'),
(158, 1, 'ilce', 61, 0, '0', 'Kepsut'),
(159, 1, 'ilce', 61, 0, '0', 'Manyas'),
(160, 1, 'ilce', 61, 0, '0', 'Marmara'),
(161, 1, 'ilce', 61, 0, '0', 'Savaştepe'),
(162, 1, 'ilce', 61, 0, '0', 'Sındırgı'),
(163, 1, 'ilce', 61, 0, '0', 'Susurluk'),
(164, 1, 'ilce', 62, 0, '0', 'Bozüyük'),
(165, 1, 'ilce', 62, 0, '0', 'Gölpazarı'),
(166, 1, 'ilce', 62, 0, '0', 'İnhisar'),
(167, 1, 'ilce', 62, 0, '0', 'Osmaneli'),
(168, 1, 'ilce', 62, 0, '0', 'Pazaryeri'),
(169, 1, 'ilce', 62, 0, '0', 'Söğüt'),
(170, 1, 'ilce', 62, 0, '0', 'Yenipazar'),
(171, 1, 'ilce', 63, 0, '0', 'Adaklı'),
(172, 1, 'ilce', 63, 0, '0', 'Genç'),
(173, 1, 'ilce', 63, 0, '0', 'Karlıova'),
(174, 1, 'ilce', 63, 0, '0', 'Kığı'),
(175, 1, 'ilce', 63, 0, '0', 'Solhan'),
(176, 1, 'ilce', 63, 0, '0', 'Yayladere'),
(177, 1, 'ilce', 63, 0, '0', 'Yedisu'),
(178, 1, 'ilce', 64, 0, '0', 'Adilcevaz'),
(179, 1, 'ilce', 64, 0, '0', 'Ahlat'),
(180, 1, 'ilce', 64, 0, '0', 'Güroymak'),
(181, 1, 'ilce', 64, 0, '0', 'Hizan'),
(182, 1, 'ilce', 64, 0, '0', 'Mutki'),
(183, 1, 'ilce', 64, 0, '0', 'Tatvan'),
(184, 1, 'ilce', 65, 0, '0', 'Dörtdivan'),
(185, 1, 'ilce', 65, 0, '0', 'Gerede'),
(186, 1, 'ilce', 65, 0, '0', 'Göynük'),
(187, 1, 'ilce', 65, 0, '0', 'Kıbrısçık'),
(188, 1, 'ilce', 65, 0, '0', 'Mengen'),
(189, 1, 'ilce', 65, 0, '0', 'Mudurnu'),
(190, 1, 'ilce', 65, 0, '0', 'Seben'),
(191, 1, 'ilce', 65, 0, '0', 'Yeniçağa'),
(192, 1, 'ilce', 67, 0, '0', 'Büyükorhan'),
(193, 1, 'ilce', 67, 0, '0', 'Gemlik'),
(194, 1, 'ilce', 67, 0, '0', 'Gürsu'),
(195, 1, 'ilce', 67, 0, '0', 'Harmancık'),
(196, 1, 'ilce', 67, 0, '0', 'İnegöl'),
(197, 1, 'ilce', 67, 0, '0', 'İznik'),
(198, 1, 'ilce', 67, 0, '0', 'Karacabey'),
(199, 1, 'ilce', 67, 0, '0', 'Keleş'),
(200, 1, 'ilce', 67, 0, '0', 'Kestel'),
(201, 1, 'ilce', 67, 0, '0', 'Mudanya'),
(202, 1, 'ilce', 67, 0, '0', 'Mustafakemalpaşa'),
(203, 1, 'ilce', 67, 0, '0', 'Nilüfer'),
(204, 1, 'ilce', 67, 0, '0', 'Orhaneli'),
(205, 1, 'ilce', 67, 0, '0', 'Orhangazi'),
(206, 1, 'ilce', 67, 0, '0', 'Osmangazi'),
(207, 1, 'ilce', 67, 0, '0', 'Yenişehir'),
(208, 1, 'ilce', 67, 0, '0', 'Yıldırım'),
(209, 1, 'ilce', 68, 0, '0', 'Ayvacık'),
(210, 1, 'ilce', 68, 0, '0', 'Bayramiç'),
(211, 1, 'ilce', 68, 0, '0', 'Biga'),
(212, 1, 'ilce', 68, 0, '0', 'Bozcaada'),
(213, 1, 'ilce', 68, 0, '0', 'Çan'),
(214, 1, 'ilce', 68, 0, '0', 'Eceabat'),
(215, 1, 'ilce', 68, 0, '0', 'Ezine'),
(216, 1, 'ilce', 68, 0, '0', 'Gelibolu'),
(217, 1, 'ilce', 68, 0, '0', 'Gökçeada'),
(218, 1, 'ilce', 68, 0, '0', 'Lapseki'),
(219, 1, 'ilce', 68, 0, '0', 'Yenice'),
(220, 1, 'ilce', 69, 0, '0', 'Atkaracalar'),
(221, 1, 'ilce', 69, 0, '0', 'Bayramören'),
(222, 1, 'ilce', 69, 0, '0', 'Çerkeş'),
(223, 1, 'ilce', 69, 0, '0', 'Eldivan'),
(224, 1, 'ilce', 69, 0, '0', 'Ilgaz'),
(225, 1, 'ilce', 69, 0, '0', 'Kızılırmak'),
(226, 1, 'ilce', 69, 0, '0', 'Korgun'),
(227, 1, 'ilce', 69, 0, '0', 'Kurşunlu'),
(228, 1, 'ilce', 69, 0, '0', 'Orta'),
(229, 1, 'ilce', 69, 0, '0', 'Şabanözü'),
(230, 1, 'ilce', 69, 0, '0', 'Yapraklı'),
(231, 1, 'ilce', 70, 0, '0', 'Alaca'),
(232, 1, 'ilce', 70, 0, '0', 'Bayat'),
(233, 1, 'ilce', 70, 0, '0', 'Boğazkale'),
(234, 1, 'ilce', 70, 0, '0', 'Dodurga'),
(235, 1, 'ilce', 70, 0, '0', 'İskilp'),
(236, 1, 'ilce', 70, 0, '0', 'Kargı'),
(237, 1, 'ilce', 70, 0, '0', 'Laçin'),
(238, 1, 'ilce', 70, 0, '0', 'Mecitözü'),
(239, 1, 'ilce', 70, 0, '0', 'Oğuzlar'),
(240, 1, 'ilce', 70, 0, '0', 'Ortaköy'),
(241, 1, 'ilce', 70, 0, '0', 'Osmancık'),
(242, 1, 'ilce', 70, 0, '0', 'Sungurlu'),
(243, 1, 'ilce', 70, 0, '0', 'Uğurludağ'),
(244, 1, 'ilce', 71, 0, '0', 'Acıpayam'),
(245, 1, 'ilce', 71, 0, '0', 'Akköy'),
(246, 1, 'ilce', 71, 0, '0', 'Babadağ'),
(247, 1, 'ilce', 71, 0, '0', 'Baklan'),
(248, 1, 'ilce', 71, 0, '0', 'Bekilli'),
(249, 1, 'ilce', 71, 0, '0', 'Beyağaç'),
(250, 1, 'ilce', 71, 0, '0', 'Bozkurt'),
(251, 1, 'ilce', 71, 0, '0', 'Buldan'),
(252, 1, 'ilce', 71, 0, '0', 'Çal'),
(253, 1, 'ilce', 71, 0, '0', 'Çameli'),
(254, 1, 'ilce', 71, 0, '0', 'Çardak'),
(255, 1, 'ilce', 71, 0, '0', 'Çivril'),
(256, 1, 'ilce', 71, 0, '0', 'Güney'),
(257, 1, 'ilce', 71, 0, '0', 'Honaz'),
(258, 1, 'ilce', 71, 0, '0', 'Kale'),
(259, 1, 'ilce', 71, 0, '0', 'Sarayköy'),
(260, 1, 'ilce', 71, 0, '0', 'Serinhisar'),
(261, 1, 'ilce', 71, 0, '0', 'Tavas'),
(262, 1, 'ilce', 72, 0, '0', 'Bağlar'),
(263, 1, 'ilce', 72, 0, '0', 'Bismil'),
(264, 1, 'ilce', 72, 0, '0', 'Çermik'),
(265, 1, 'ilce', 72, 0, '0', 'Çınar'),
(266, 1, 'ilce', 72, 0, '0', 'Çüngüş'),
(267, 1, 'ilce', 72, 0, '0', 'Dicle'),
(268, 1, 'ilce', 72, 0, '0', 'Eğil'),
(269, 1, 'ilce', 72, 0, '0', 'Ergani'),
(270, 1, 'ilce', 72, 0, '0', 'Hani'),
(271, 1, 'ilce', 72, 0, '0', 'Hazro'),
(272, 1, 'ilce', 72, 0, '0', 'Kayapınar'),
(273, 1, 'ilce', 72, 0, '0', 'Kocaköy'),
(274, 1, 'ilce', 72, 0, '0', 'Kulp'),
(275, 1, 'ilce', 72, 0, '0', 'Lice'),
(276, 1, 'ilce', 72, 0, '0', 'Silvan'),
(277, 1, 'ilce', 72, 0, '0', 'Sur'),
(278, 1, 'ilce', 72, 0, '0', 'Yenişehir'),
(279, 1, 'ilce', 73, 0, '0', 'Enez'),
(280, 1, 'ilce', 73, 0, '0', 'Havsa'),
(281, 1, 'ilce', 73, 0, '0', 'İpsala'),
(282, 1, 'ilce', 73, 0, '0', 'Keşan'),
(283, 1, 'ilce', 73, 0, '0', 'Lalapaşa'),
(284, 1, 'ilce', 73, 0, '0', 'Meriç'),
(285, 1, 'ilce', 73, 0, '0', 'Süloğlu'),
(286, 1, 'ilce', 73, 0, '0', 'Uzunköprü'),
(287, 1, 'ilce', 74, 0, '0', 'Ağın'),
(288, 1, 'ilce', 74, 0, '0', 'Alacakaya'),
(289, 1, 'ilce', 74, 0, '0', 'Arıcak'),
(290, 1, 'ilce', 74, 0, '0', 'Baskil'),
(291, 1, 'ilce', 74, 0, '0', 'Karakoçan'),
(292, 1, 'ilce', 74, 0, '0', 'Keban'),
(293, 1, 'ilce', 74, 0, '0', 'Kovancılar'),
(294, 1, 'ilce', 74, 0, '0', 'Maden'),
(295, 1, 'ilce', 74, 0, '0', 'Palu'),
(296, 1, 'ilce', 74, 0, '0', 'Sivrice'),
(297, 1, 'ilce', 75, 0, '0', 'Çayırlı'),
(298, 1, 'ilce', 75, 0, '0', 'İliç'),
(299, 1, 'ilce', 75, 0, '0', 'Kemah'),
(300, 1, 'ilce', 75, 0, '0', 'Kemaliye'),
(301, 1, 'ilce', 75, 0, '0', 'Otlukbeli'),
(302, 1, 'ilce', 75, 0, '0', 'Refahiye'),
(303, 1, 'ilce', 75, 0, '0', 'Tercan'),
(304, 1, 'ilce', 75, 0, '0', 'Üzümlü'),
(305, 1, 'ilce', 76, 0, '0', 'Aşkale'),
(306, 1, 'ilce', 76, 0, '0', 'Aziziye'),
(307, 1, 'ilce', 76, 0, '0', 'Çat'),
(308, 1, 'ilce', 76, 0, '0', 'Hınıs'),
(309, 1, 'ilce', 76, 0, '0', 'Horasan'),
(310, 1, 'ilce', 76, 0, '0', 'İspir'),
(311, 1, 'ilce', 76, 0, '0', 'Karaçoban'),
(312, 1, 'ilce', 76, 0, '0', 'Karayazı'),
(313, 1, 'ilce', 76, 0, '0', 'Köprüköy'),
(314, 1, 'ilce', 76, 0, '0', 'Narman'),
(315, 1, 'ilce', 76, 0, '0', 'Oltu'),
(316, 1, 'ilce', 76, 0, '0', 'Olur'),
(317, 1, 'ilce', 76, 0, '0', 'Palandöken'),
(318, 1, 'ilce', 76, 0, '0', 'Pasinler'),
(319, 1, 'ilce', 76, 0, '0', 'Pazaryolu'),
(320, 1, 'ilce', 76, 0, '0', 'Şenkaya'),
(321, 1, 'ilce', 76, 0, '0', 'Tekman'),
(322, 1, 'ilce', 76, 0, '0', 'Tortum'),
(323, 1, 'ilce', 76, 0, '0', 'Uzundere'),
(324, 1, 'ilce', 76, 0, '0', 'Yakutiye'),
(325, 1, 'ilce', 77, 0, '0', 'Alpu'),
(326, 1, 'ilce', 77, 0, '0', 'Beylikova'),
(327, 1, 'ilce', 77, 0, '0', 'Çifteler'),
(328, 1, 'ilce', 77, 0, '0', 'Günyüzü'),
(329, 1, 'ilce', 77, 0, '0', 'Han'),
(330, 1, 'ilce', 77, 0, '0', 'İnönü'),
(331, 1, 'ilce', 77, 0, '0', 'Mahmudiye'),
(332, 1, 'ilce', 77, 0, '0', 'Mihalgazi'),
(333, 1, 'ilce', 77, 0, '0', 'Mihalıççık'),
(334, 1, 'ilce', 77, 0, '0', 'Odunpazarı'),
(335, 1, 'ilce', 77, 0, '0', 'Sarıcakaya'),
(336, 1, 'ilce', 77, 0, '0', 'Seyitgazi'),
(337, 1, 'ilce', 77, 0, '0', 'Sivrihisar'),
(338, 1, 'ilce', 77, 0, '0', 'Tepebaşı'),
(339, 1, 'ilce', 78, 0, '0', 'Araban'),
(340, 1, 'ilce', 78, 0, '0', 'İslahiye'),
(341, 1, 'ilce', 78, 0, '0', 'Karkamış'),
(342, 1, 'ilce', 78, 0, '0', 'Nizip'),
(343, 1, 'ilce', 78, 0, '0', 'Nurdağı'),
(344, 1, 'ilce', 78, 0, '0', 'Oğuzeli'),
(345, 1, 'ilce', 78, 0, '0', 'Şahinbey'),
(346, 1, 'ilce', 78, 0, '0', 'Şehit Kamil'),
(347, 1, 'ilce', 78, 0, '0', 'Yavuzeli'),
(348, 1, 'ilce', 79, 0, '0', 'Alucra'),
(349, 1, 'ilce', 79, 0, '0', 'Bulancak'),
(350, 1, 'ilce', 79, 0, '0', 'Çamoluk'),
(351, 1, 'ilce', 79, 0, '0', 'Çanakçı'),
(352, 1, 'ilce', 79, 0, '0', 'Dereli'),
(353, 1, 'ilce', 79, 0, '0', 'Doğankent'),
(354, 1, 'ilce', 79, 0, '0', 'Espiye'),
(355, 1, 'ilce', 79, 0, '0', 'Eynesil'),
(356, 1, 'ilce', 79, 0, '0', 'Görele'),
(357, 1, 'ilce', 79, 0, '0', 'Güce'),
(358, 1, 'ilce', 79, 0, '0', 'Keşap'),
(359, 1, 'ilce', 79, 0, '0', 'Piraziz'),
(360, 1, 'ilce', 79, 0, '0', 'Şebinkarahisar'),
(361, 1, 'ilce', 79, 0, '0', 'Tirebolu'),
(362, 1, 'ilce', 79, 0, '0', 'Yağlıdere'),
(363, 1, 'ilce', 80, 0, '0', 'Kelkit'),
(364, 1, 'ilce', 80, 0, '0', 'Köse'),
(365, 1, 'ilce', 80, 0, '0', 'Kürtün'),
(366, 1, 'ilce', 80, 0, '0', 'Siran'),
(367, 1, 'ilce', 80, 0, '0', 'Torul'),
(368, 1, 'ilce', 81, 0, '0', 'Çukurca'),
(369, 1, 'ilce', 81, 0, '0', 'Şemdinli'),
(370, 1, 'ilce', 81, 0, '0', 'Yüksekova'),
(371, 1, 'ilce', 82, 0, '0', 'Altınözü'),
(372, 1, 'ilce', 82, 0, '0', 'Belen'),
(373, 1, 'ilce', 82, 0, '0', 'Dörtyol'),
(374, 1, 'ilce', 82, 0, '0', 'Erzin'),
(375, 1, 'ilce', 82, 0, '0', 'Hassa'),
(376, 1, 'ilce', 82, 0, '0', 'İskenderun'),
(377, 1, 'ilce', 82, 0, '0', 'Kırıkhan'),
(378, 1, 'ilce', 82, 0, '0', 'Kumlu'),
(379, 1, 'ilce', 82, 0, '0', 'Samandağ'),
(380, 1, 'ilce', 82, 0, '0', 'Yayladağ'),
(381, 1, 'ilce', 84, 0, '0', 'Akdeniz'),
(382, 1, 'ilce', 84, 0, '0', 'Anamur'),
(383, 1, 'ilce', 84, 0, '0', 'Aydıncık'),
(384, 1, 'ilce', 84, 0, '0', 'Bozyazı'),
(385, 1, 'ilce', 84, 0, '0', 'Çamlıyayla'),
(386, 1, 'ilce', 84, 0, '0', 'Erdemli'),
(387, 1, 'ilce', 84, 0, '0', 'Gülnar'),
(388, 1, 'ilce', 84, 0, '0', 'Mezitli'),
(389, 1, 'ilce', 84, 0, '0', 'Mut'),
(390, 1, 'ilce', 84, 0, '0', 'Silifke'),
(391, 1, 'ilce', 84, 0, '0', 'Tarsus'),
(392, 1, 'ilce', 84, 0, '0', 'Toroslar'),
(393, 1, 'ilce', 84, 0, '0', 'Yenişehir'),
(394, 1, 'ilce', 85, 0, '0', 'Adalar'),
(395, 1, 'ilce', 85, 0, '0', 'Arnavutköy'),
(396, 1, 'ilce', 85, 0, '0', 'Ataşehir'),
(397, 1, 'ilce', 85, 0, '0', 'Avcılar'),
(398, 1, 'ilce', 85, 0, '0', 'Bağcılar'),
(399, 1, 'ilce', 85, 0, '0', 'Bahçelievler'),
(400, 1, 'ilce', 85, 0, '0', 'Bakırköy'),
(401, 1, 'ilce', 85, 0, '0', 'Başakşehir'),
(402, 1, 'ilce', 85, 0, '0', 'Bayrampaşa'),
(403, 1, 'ilce', 85, 0, '0', 'Beşiktaş'),
(404, 1, 'ilce', 85, 0, '0', 'Beykoz'),
(405, 1, 'ilce', 85, 0, '0', 'Beylikdüzü'),
(406, 1, 'ilce', 85, 0, '0', 'Beyoğlu'),
(407, 1, 'ilce', 85, 0, '0', 'Büyükçekmece'),
(408, 1, 'ilce', 85, 0, '0', 'Çatalca'),
(409, 1, 'ilce', 85, 0, '0', 'Çekmeköy'),
(410, 1, 'ilce', 85, 0, '0', 'Esenler'),
(411, 1, 'ilce', 85, 0, '0', 'Esenyurt'),
(412, 1, 'ilce', 85, 0, '0', 'Eyüp'),
(413, 1, 'ilce', 85, 0, '0', 'Fatih'),
(414, 1, 'ilce', 85, 0, '0', 'Gaziosmanpaşa'),
(415, 1, 'ilce', 85, 0, '0', 'Güngören'),
(416, 1, 'ilce', 85, 0, '0', 'Kadıköy'),
(417, 1, 'ilce', 85, 0, '0', 'Kağıthane'),
(418, 1, 'ilce', 85, 0, '0', 'Kartal'),
(419, 1, 'ilce', 85, 0, '0', 'Küçükçekmece'),
(420, 1, 'ilce', 85, 0, '0', 'Maltepe'),
(421, 1, 'ilce', 85, 0, '0', 'Pendik'),
(422, 1, 'ilce', 85, 0, '0', 'Sancaktepe'),
(423, 1, 'ilce', 85, 0, '0', 'Sarıyer'),
(424, 1, 'ilce', 85, 0, '0', 'Silivri'),
(425, 1, 'ilce', 85, 0, '0', 'Sultanbeyli'),
(426, 1, 'ilce', 85, 0, '0', 'Sultangazi'),
(427, 1, 'ilce', 85, 0, '0', 'Şile'),
(428, 1, 'ilce', 85, 0, '0', 'Şişli'),
(429, 1, 'ilce', 85, 0, '0', 'Tuzla'),
(430, 1, 'ilce', 85, 0, '0', 'Ümraniye'),
(431, 1, 'ilce', 85, 0, '0', 'Üsküdar'),
(432, 1, 'ilce', 85, 0, '0', 'Zeytinburnu'),
(433, 1, 'ilce', 86, 0, '0', 'Aliağa'),
(434, 1, 'ilce', 86, 0, '0', 'Balçova'),
(435, 1, 'ilce', 86, 0, '0', 'Bayındır'),
(436, 1, 'ilce', 86, 0, '0', 'Bayraklı'),
(437, 1, 'ilce', 86, 0, '0', 'Bergama'),
(438, 1, 'ilce', 86, 0, '0', 'Beydağ'),
(439, 1, 'ilce', 86, 0, '0', 'Bornova'),
(440, 1, 'ilce', 86, 0, '0', 'Buca'),
(441, 1, 'ilce', 86, 0, '0', 'Çeşme'),
(442, 1, 'ilce', 86, 0, '0', 'Çiğli'),
(443, 1, 'ilce', 86, 0, '0', 'Dikili'),
(444, 1, 'ilce', 86, 0, '0', 'Foça'),
(445, 1, 'ilce', 86, 0, '0', 'Gaziemir'),
(446, 1, 'ilce', 86, 0, '0', 'Güzelbahçe'),
(447, 1, 'ilce', 86, 0, '0', 'Karabağlar'),
(448, 1, 'ilce', 86, 0, '0', 'Karaburun'),
(449, 1, 'ilce', 86, 0, '0', 'Karşıyaka'),
(450, 1, 'ilce', 86, 0, '0', 'Kemalpaşa'),
(451, 1, 'ilce', 86, 0, '0', 'Kınık'),
(452, 1, 'ilce', 86, 0, '0', 'Kiraz'),
(453, 1, 'ilce', 86, 0, '0', 'Konak'),
(454, 1, 'ilce', 86, 0, '0', 'Menderes'),
(455, 1, 'ilce', 86, 0, '0', 'Menemen'),
(456, 1, 'ilce', 86, 0, '0', 'Narlıdere'),
(457, 1, 'ilce', 86, 0, '0', 'Ödemiş'),
(458, 1, 'ilce', 86, 0, '0', 'Seferihisar'),
(459, 1, 'ilce', 86, 0, '0', 'Selçuk'),
(460, 1, 'ilce', 86, 0, '0', 'Tire'),
(461, 1, 'ilce', 86, 0, '0', 'Torbalı'),
(462, 1, 'ilce', 86, 0, '0', 'Urla'),
(463, 1, 'ilce', 87, 0, '0', 'Akyaka'),
(464, 1, 'ilce', 87, 0, '0', 'Arpaçay'),
(465, 1, 'ilce', 87, 0, '0', 'Digor'),
(466, 1, 'ilce', 87, 0, '0', 'Kağızman'),
(467, 1, 'ilce', 87, 0, '0', 'Sarıkamış'),
(468, 1, 'ilce', 87, 0, '0', 'Selim'),
(469, 1, 'ilce', 87, 0, '0', 'Susuz'),
(470, 1, 'ilce', 88, 0, '0', 'Abana'),
(471, 1, 'ilce', 88, 0, '0', 'Ağlı'),
(472, 1, 'ilce', 88, 0, '0', 'Araç'),
(473, 1, 'ilce', 88, 0, '0', 'Azdavay'),
(474, 1, 'ilce', 88, 0, '0', 'Bozkurt'),
(475, 1, 'ilce', 88, 0, '0', 'Cide'),
(476, 1, 'ilce', 88, 0, '0', 'Çatalzeytin'),
(477, 1, 'ilce', 88, 0, '0', 'Daday'),
(478, 1, 'ilce', 88, 0, '0', 'Devrekani'),
(479, 1, 'ilce', 88, 0, '0', 'Doğanyurt'),
(480, 1, 'ilce', 88, 0, '0', 'Hanönü'),
(481, 1, 'ilce', 88, 0, '0', 'İhsangazi'),
(482, 1, 'ilce', 88, 0, '0', 'İnebolu'),
(483, 1, 'ilce', 88, 0, '0', 'Küre'),
(484, 1, 'ilce', 88, 0, '0', 'Pınarbaşı'),
(485, 1, 'ilce', 88, 0, '0', 'Seydiler'),
(486, 1, 'ilce', 88, 0, '0', 'Şenpazar'),
(487, 1, 'ilce', 88, 0, '0', 'Taşköprü'),
(488, 1, 'ilce', 88, 0, '0', 'Tosya'),
(489, 1, 'ilce', 89, 0, '0', 'Akkışla'),
(490, 1, 'ilce', 89, 0, '0', 'Bünyan'),
(491, 1, 'ilce', 89, 0, '0', 'Develi'),
(492, 1, 'ilce', 89, 0, '0', 'Felahiye'),
(493, 1, 'ilce', 89, 0, '0', 'Hacılar'),
(494, 1, 'ilce', 89, 0, '0', 'İncesu'),
(495, 1, 'ilce', 89, 0, '0', 'Kocasinan'),
(496, 1, 'ilce', 89, 0, '0', 'Melikgazi'),
(497, 1, 'ilce', 89, 0, '0', 'Özvatan'),
(498, 1, 'ilce', 89, 0, '0', 'Pınarbaşı'),
(499, 1, 'ilce', 89, 0, '0', 'Sarıoğlan'),
(500, 1, 'ilce', 89, 0, '0', 'Sarız'),
(501, 1, 'ilce', 89, 0, '0', 'Talas'),
(502, 1, 'ilce', 89, 0, '0', 'Tomarza'),
(503, 1, 'ilce', 89, 0, '0', 'Yahyalı'),
(504, 1, 'ilce', 89, 0, '0', 'Yeşilhisar'),
(505, 1, 'ilce', 90, 0, '0', 'Babaeski'),
(506, 1, 'ilce', 90, 0, '0', 'Demirköy'),
(507, 1, 'ilce', 90, 0, '0', 'Kofçaz'),
(508, 1, 'ilce', 90, 0, '0', 'Lüleburgaz'),
(509, 1, 'ilce', 90, 0, '0', 'Pehlivanköy'),
(510, 1, 'ilce', 90, 0, '0', 'Pınarhisar'),
(511, 1, 'ilce', 90, 0, '0', 'Vize'),
(512, 1, 'ilce', 91, 0, '0', 'Akçakent'),
(513, 1, 'ilce', 91, 0, '0', 'Akpınar'),
(514, 1, 'ilce', 91, 0, '0', 'Boztepe'),
(515, 1, 'ilce', 91, 0, '0', 'Çiçekdağı'),
(516, 1, 'ilce', 91, 0, '0', 'Kaman'),
(517, 1, 'ilce', 91, 0, '0', 'Mucur'),
(518, 1, 'ilce', 92, 0, '0', 'Başiskele'),
(519, 1, 'ilce', 92, 0, '0', 'Çayırova'),
(520, 1, 'ilce', 92, 0, '0', 'Darıca'),
(521, 1, 'ilce', 92, 0, '0', 'Derince'),
(522, 1, 'ilce', 92, 0, '0', 'Dilovası'),
(523, 1, 'ilce', 92, 0, '0', 'Gebze'),
(524, 1, 'ilce', 92, 0, '0', 'Gölcük'),
(525, 1, 'ilce', 92, 0, '0', 'İzmit'),
(526, 1, 'ilce', 92, 0, '0', 'Kandıra'),
(527, 1, 'ilce', 92, 0, '0', 'Karamürsel'),
(528, 1, 'ilce', 92, 0, '0', 'Kartepe'),
(529, 1, 'ilce', 92, 0, '0', 'Körfez'),
(530, 1, 'ilce', 93, 0, '0', 'Ahırlı'),
(531, 1, 'ilce', 93, 0, '0', 'Akören'),
(532, 1, 'ilce', 93, 0, '0', 'Akşehir'),
(533, 1, 'ilce', 93, 0, '0', 'Altınekin'),
(534, 1, 'ilce', 93, 0, '0', 'Beyşehir'),
(535, 1, 'ilce', 93, 0, '0', 'Bozkır'),
(536, 1, 'ilce', 93, 0, '0', 'Cihanbeyli'),
(537, 1, 'ilce', 93, 0, '0', 'Çeltik'),
(538, 1, 'ilce', 93, 0, '0', 'Çumra'),
(539, 1, 'ilce', 93, 0, '0', 'Derbent'),
(540, 1, 'ilce', 93, 0, '0', 'Derebucak'),
(541, 1, 'ilce', 93, 0, '0', 'Doğanhisar'),
(542, 1, 'ilce', 93, 0, '0', 'Emirgazi'),
(543, 1, 'ilce', 93, 0, '0', 'Ereğli'),
(544, 1, 'ilce', 93, 0, '0', 'Güneysınır'),
(545, 1, 'ilce', 93, 0, '0', 'Hadim'),
(546, 1, 'ilce', 93, 0, '0', 'Halkapınar'),
(547, 1, 'ilce', 93, 0, '0', 'Hüyük'),
(548, 1, 'ilce', 93, 0, '0', 'Ilgın'),
(549, 1, 'ilce', 93, 0, '0', 'Kadınhanı'),
(550, 1, 'ilce', 93, 0, '0', 'Karapınar'),
(551, 1, 'ilce', 93, 0, '0', 'Karatay'),
(552, 1, 'ilce', 93, 0, '0', 'Kulu'),
(553, 1, 'ilce', 93, 0, '0', 'Meram'),
(554, 1, 'ilce', 93, 0, '0', 'Sarayönü'),
(555, 1, 'ilce', 93, 0, '0', 'Selçuklu'),
(556, 1, 'ilce', 93, 0, '0', 'Seydişehir'),
(557, 1, 'ilce', 93, 0, '0', 'Taşkent'),
(558, 1, 'ilce', 93, 0, '0', 'Tuzlukçu'),
(559, 1, 'ilce', 93, 0, '0', 'Yalıhüyük'),
(560, 1, 'ilce', 93, 0, '0', 'Yunak'),
(561, 1, 'ilce', 94, 0, '0', 'Merkez'),
(562, 1, 'ilce', 94, 0, '0', 'Altıntaş'),
(563, 1, 'ilce', 94, 0, '0', 'Aslanapa'),
(564, 1, 'ilce', 94, 0, '0', 'Çavdarhisar'),
(565, 1, 'ilce', 94, 0, '0', 'Domaniç'),
(566, 1, 'ilce', 94, 0, '0', 'Dumlupınar'),
(567, 1, 'ilce', 94, 0, '0', 'Emet'),
(568, 1, 'ilce', 94, 0, '0', 'Gediz'),
(569, 1, 'ilce', 94, 0, '0', 'Hisarcık'),
(570, 1, 'ilce', 94, 0, '0', 'Pazarlar'),
(571, 1, 'ilce', 94, 0, '0', 'Simav'),
(572, 1, 'ilce', 94, 0, '0', 'Şaphane'),
(573, 1, 'ilce', 94, 0, '0', 'Tavşanlı'),
(574, 1, 'ilce', 95, 0, '0', 'Merkez'),
(575, 1, 'ilce', 95, 0, '0', 'Akçadağ'),
(576, 1, 'ilce', 95, 0, '0', 'Arapgir'),
(577, 1, 'ilce', 95, 0, '0', 'Arguvan'),
(578, 1, 'ilce', 95, 0, '0', 'Battalgazi'),
(579, 1, 'ilce', 95, 0, '0', 'Darende'),
(580, 1, 'ilce', 95, 0, '0', 'Doğanşehir'),
(581, 1, 'ilce', 95, 0, '0', 'Doğanyol'),
(582, 1, 'ilce', 95, 0, '0', 'Hekimhan'),
(583, 1, 'ilce', 95, 0, '0', 'Kale'),
(584, 1, 'ilce', 95, 0, '0', 'Kuluncak'),
(585, 1, 'ilce', 95, 0, '0', 'Pütürge'),
(586, 1, 'ilce', 95, 0, '0', 'Yazıhan'),
(587, 1, 'ilce', 95, 0, '0', 'Yeşilyurt'),
(588, 1, 'ilce', 96, 0, '0', 'Şehzadeler - Yunusemre'),
(589, 1, 'ilce', 96, 0, '0', 'Ahmetli'),
(590, 1, 'ilce', 96, 0, '0', 'Akhisar'),
(591, 1, 'ilce', 96, 0, '0', 'Alaşehir'),
(592, 1, 'ilce', 96, 0, '0', 'Demirci'),
(593, 1, 'ilce', 96, 0, '0', 'Gölmarmara'),
(594, 1, 'ilce', 96, 0, '0', 'Gördes'),
(595, 1, 'ilce', 96, 0, '0', 'Kırkağaç'),
(596, 1, 'ilce', 96, 0, '0', 'Köprübaşı'),
(597, 1, 'ilce', 96, 0, '0', 'Kula'),
(598, 1, 'ilce', 96, 0, '0', 'Salihli'),
(599, 1, 'ilce', 96, 0, '0', 'Sarıgöl'),
(600, 1, 'ilce', 96, 0, '0', 'Saruhanlı'),
(601, 1, 'ilce', 96, 0, '0', 'Selendi'),
(602, 1, 'ilce', 96, 0, '0', 'Soma'),
(603, 1, 'ilce', 96, 0, '0', 'Turgutlu'),
(604, 1, 'ilce', 97, 0, '0', 'Onikişubat'),
(605, 1, 'ilce', 97, 0, '0', 'Afşin'),
(606, 1, 'ilce', 97, 0, '0', 'Andırın'),
(607, 1, 'ilce', 97, 0, '0', 'Çağlayancerit'),
(608, 1, 'ilce', 97, 0, '0', 'Ekinözü'),
(609, 1, 'ilce', 97, 0, '0', 'Elbistan'),
(610, 1, 'ilce', 97, 0, '0', 'Göksun'),
(611, 1, 'ilce', 97, 0, '0', 'Nurhak'),
(612, 1, 'ilce', 97, 0, '0', 'Pazarcık'),
(613, 1, 'ilce', 97, 0, '0', 'Türkoğlu'),
(614, 1, 'ilce', 98, 0, '0', 'Merkez'),
(615, 1, 'ilce', 98, 0, '0', 'Dargeçit'),
(616, 1, 'ilce', 98, 0, '0', 'Derik'),
(617, 1, 'ilce', 98, 0, '0', 'Kızıltepe'),
(618, 1, 'ilce', 98, 0, '0', 'Mazıdağı'),
(619, 1, 'ilce', 98, 0, '0', 'Midyat'),
(620, 1, 'ilce', 98, 0, '0', 'Nusaybin'),
(621, 1, 'ilce', 98, 0, '0', 'Ömerli'),
(622, 1, 'ilce', 98, 0, '0', 'Savur'),
(623, 1, 'ilce', 98, 0, '0', 'Yeşilli'),
(624, 1, 'ilce', 99, 0, '0', 'Merkez'),
(625, 1, 'ilce', 99, 0, '0', 'Bodrum'),
(626, 1, 'ilce', 99, 0, '0', 'Dalaman'),
(627, 1, 'ilce', 99, 0, '0', 'Datça'),
(628, 1, 'ilce', 99, 0, '0', 'Fethiye'),
(629, 1, 'ilce', 99, 0, '0', 'Kavaklıdere'),
(630, 1, 'ilce', 99, 0, '0', 'Köyçeğiz'),
(631, 1, 'ilce', 99, 0, '0', 'Marmaris'),
(632, 1, 'ilce', 99, 0, '0', 'Milas'),
(633, 1, 'ilce', 99, 0, '0', 'Ortaca'),
(634, 1, 'ilce', 99, 0, '0', 'Ula'),
(635, 1, 'ilce', 99, 0, '0', 'Yatağan'),
(636, 1, 'ilce', 100, 0, '0', 'Merkez'),
(637, 1, 'ilce', 100, 0, '0', 'Bulanık'),
(638, 1, 'ilce', 100, 0, '0', 'Hasköy'),
(639, 1, 'ilce', 100, 0, '0', 'Korkut'),
(640, 1, 'ilce', 100, 0, '0', 'Malazgirt'),
(641, 1, 'ilce', 100, 0, '0', 'Varto'),
(642, 1, 'ilce', 101, 0, '0', 'Merkez'),
(643, 1, 'ilce', 101, 0, '0', 'Acıgöl'),
(644, 1, 'ilce', 101, 0, '0', 'Avanos'),
(645, 1, 'ilce', 101, 0, '0', 'Derinkuyu'),
(646, 1, 'ilce', 101, 0, '0', 'Gülşehir'),
(647, 1, 'ilce', 101, 0, '0', 'Hacıbektaş'),
(648, 1, 'ilce', 101, 0, '0', 'Kozaklı'),
(649, 1, 'ilce', 101, 0, '0', 'Ürgüp'),
(650, 1, 'ilce', 102, 0, '0', 'Merkez'),
(651, 1, 'ilce', 102, 0, '0', 'Altınhisar'),
(652, 1, 'ilce', 102, 0, '0', 'Bor'),
(653, 1, 'ilce', 102, 0, '0', 'Çamardı'),
(654, 1, 'ilce', 102, 0, '0', 'Çiftlik'),
(655, 1, 'ilce', 102, 0, '0', 'Ulukışla'),
(656, 1, 'ilce', 103, 0, '0', 'Merkez'),
(657, 1, 'ilce', 103, 0, '0', 'Akkuş'),
(658, 1, 'ilce', 103, 0, '0', 'Aybastı'),
(659, 1, 'ilce', 103, 0, '0', 'Çamaş'),
(660, 1, 'ilce', 103, 0, '0', 'Çatalpınar'),
(661, 1, 'ilce', 103, 0, '0', 'Çaybaşı'),
(662, 1, 'ilce', 103, 0, '0', 'Fatsa'),
(663, 1, 'ilce', 103, 0, '0', 'Gölköy'),
(664, 1, 'ilce', 103, 0, '0', 'Gülyalı'),
(665, 1, 'ilce', 103, 0, '0', 'Gürgentepe'),
(666, 1, 'ilce', 103, 0, '0', 'İkizce'),
(667, 1, 'ilce', 103, 0, '0', 'Karadüz'),
(668, 1, 'ilce', 103, 0, '0', 'Kabataş'),
(669, 1, 'ilce', 103, 0, '0', 'Korgan'),
(670, 1, 'ilce', 103, 0, '0', 'Kumru'),
(671, 1, 'ilce', 103, 0, '0', 'Mesudiye'),
(672, 1, 'ilce', 103, 0, '0', 'Perşembe'),
(673, 1, 'ilce', 103, 0, '0', 'Ulubey'),
(674, 1, 'ilce', 103, 0, '0', 'Ünye'),
(675, 1, 'ilce', 104, 0, '0', 'Merkez'),
(676, 1, 'ilce', 104, 0, '0', 'Ardeşen'),
(677, 1, 'ilce', 104, 0, '0', 'Çamlıhemşin'),
(678, 1, 'ilce', 104, 0, '0', 'Çayeli'),
(679, 1, 'ilce', 104, 0, '0', 'Derepazarı'),
(680, 1, 'ilce', 104, 0, '0', 'Fındıklı'),
(681, 1, 'ilce', 104, 0, '0', 'Güneysu'),
(682, 1, 'ilce', 104, 0, '0', 'Hemşin'),
(683, 1, 'ilce', 104, 0, '0', 'İkizdere'),
(684, 1, 'ilce', 104, 0, '0', 'İyidere'),
(685, 1, 'ilce', 104, 0, '0', 'Kalkandere'),
(686, 1, 'ilce', 104, 0, '0', 'Pazar'),
(687, 1, 'ilce', 105, 0, '0', 'Merkez'),
(688, 1, 'ilce', 105, 0, '0', 'Adapazarı'),
(689, 1, 'ilce', 105, 0, '0', 'Akyazı'),
(690, 1, 'ilce', 105, 0, '0', 'Arifiye'),
(691, 1, 'ilce', 105, 0, '0', 'Erenler'),
(692, 1, 'ilce', 105, 0, '0', 'Ferizli'),
(693, 1, 'ilce', 105, 0, '0', 'Geyve'),
(694, 1, 'ilce', 105, 0, '0', 'Hendek'),
(695, 1, 'ilce', 105, 0, '0', 'Karapürçek'),
(696, 1, 'ilce', 105, 0, '0', 'Karasu'),
(697, 1, 'ilce', 105, 0, '0', 'Kaynarca'),
(698, 1, 'ilce', 105, 0, '0', 'Kocaali'),
(699, 1, 'ilce', 105, 0, '0', 'Pamukova'),
(700, 1, 'ilce', 105, 0, '0', 'Sapanca'),
(701, 1, 'ilce', 105, 0, '0', 'Serdivan'),
(702, 1, 'ilce', 105, 0, '0', 'Söğütlü'),
(703, 1, 'ilce', 105, 0, '0', 'Taraklı'),
(704, 1, 'ilce', 106, 0, '0', 'Merkez'),
(705, 1, 'ilce', 106, 0, '0', 'Alaçam'),
(706, 1, 'ilce', 106, 0, '0', 'Asarcık'),
(707, 1, 'ilce', 106, 0, '0', 'Atakum'),
(708, 1, 'ilce', 106, 0, '0', 'Ayvacık'),
(709, 1, 'ilce', 106, 0, '0', 'Bafra'),
(710, 1, 'ilce', 106, 0, '0', 'Canik'),
(711, 1, 'ilce', 106, 0, '0', 'Çarşamba'),
(712, 1, 'ilce', 106, 0, '0', 'Havza'),
(713, 1, 'ilce', 106, 0, '0', 'İlkadım'),
(714, 1, 'ilce', 106, 0, '0', 'Kavak'),
(715, 1, 'ilce', 106, 0, '0', 'Ladik'),
(716, 1, 'ilce', 106, 0, '0', 'Ondokuzmayız'),
(717, 1, 'ilce', 106, 0, '0', 'Salıpazarı'),
(718, 1, 'ilce', 106, 0, '0', 'Tekkeköy'),
(719, 1, 'ilce', 106, 0, '0', 'Terme'),
(720, 1, 'ilce', 106, 0, '0', 'Vezirköprü'),
(721, 1, 'ilce', 106, 0, '0', 'Yakakent'),
(722, 1, 'ilce', 107, 0, '0', 'Merkez'),
(723, 1, 'ilce', 107, 0, '0', 'Aydınlar'),
(724, 1, 'ilce', 107, 0, '0', 'Baykan'),
(725, 1, 'ilce', 107, 0, '0', 'Eruh'),
(726, 1, 'ilce', 107, 0, '0', 'Kurtalan'),
(727, 1, 'ilce', 107, 0, '0', 'Pervari'),
(728, 1, 'ilce', 107, 0, '0', 'Şirvan'),
(729, 1, 'ilce', 108, 0, '0', 'Merkez'),
(730, 1, 'ilce', 108, 0, '0', 'Ayancık'),
(731, 1, 'ilce', 108, 0, '0', 'Boyabat'),
(732, 1, 'ilce', 108, 0, '0', 'Dikmen'),
(733, 1, 'ilce', 108, 0, '0', 'Durağan'),
(734, 1, 'ilce', 108, 0, '0', 'Erfelek'),
(735, 1, 'ilce', 108, 0, '0', 'Gerze'),
(736, 1, 'ilce', 108, 0, '0', 'Saraydüzü'),
(737, 1, 'ilce', 108, 0, '0', 'Türkeli'),
(738, 1, 'ilce', 109, 0, '0', 'Merkez'),
(739, 1, 'ilce', 109, 0, '0', 'Akıncılar'),
(740, 1, 'ilce', 109, 0, '0', 'Altınyayla'),
(741, 1, 'ilce', 109, 0, '0', 'Divriği'),
(742, 1, 'ilce', 109, 0, '0', 'Doğanşar'),
(743, 1, 'ilce', 109, 0, '0', 'Gemerek'),
(744, 1, 'ilce', 109, 0, '0', 'Gölova'),
(745, 1, 'ilce', 109, 0, '0', 'Gürün'),
(746, 1, 'ilce', 109, 0, '0', 'Hafik'),
(747, 1, 'ilce', 109, 0, '0', 'İmranlı'),
(748, 1, 'ilce', 109, 0, '0', 'Kangal'),
(749, 1, 'ilce', 109, 0, '0', 'Koyulhisar'),
(750, 1, 'ilce', 109, 0, '0', 'Suşehri'),
(751, 1, 'ilce', 109, 0, '0', 'Şarkışla'),
(752, 1, 'ilce', 109, 0, '0', 'Ulaş'),
(753, 1, 'ilce', 109, 0, '0', 'Yıldızeli'),
(754, 1, 'ilce', 109, 0, '0', 'Zara'),
(755, 1, 'ilce', 110, 0, '0', 'Merkez'),
(756, 1, 'ilce', 110, 0, '0', 'Çerkezköy'),
(757, 1, 'ilce', 110, 0, '0', 'Çorlu'),
(758, 1, 'ilce', 110, 0, '0', 'Hayrabolu'),
(759, 1, 'ilce', 110, 0, '0', 'Malkara'),
(760, 1, 'ilce', 110, 0, '0', 'Marmaraereğlisi'),
(761, 1, 'ilce', 110, 0, '0', 'Muratlı'),
(762, 1, 'ilce', 110, 0, '0', 'Saray'),
(763, 1, 'ilce', 110, 0, '0', 'Şarköy'),
(764, 1, 'ilce', 111, 0, '0', 'Merkez'),
(765, 1, 'ilce', 111, 0, '0', 'Almus'),
(766, 1, 'ilce', 111, 0, '0', 'Artova'),
(767, 1, 'ilce', 111, 0, '0', 'Başçiftlik'),
(768, 1, 'ilce', 111, 0, '0', 'Erbaa'),
(769, 1, 'ilce', 111, 0, '0', 'Niksar'),
(770, 1, 'ilce', 111, 0, '0', 'Pazar'),
(771, 1, 'ilce', 111, 0, '0', 'Reşadiye'),
(772, 1, 'ilce', 111, 0, '0', 'Sulusaray'),
(773, 1, 'ilce', 111, 0, '0', 'Turhal'),
(774, 1, 'ilce', 111, 0, '0', 'Yeşilyurt'),
(775, 1, 'ilce', 111, 0, '0', 'Zile'),
(776, 1, 'ilce', 112, 0, '0', 'Merkez'),
(777, 1, 'ilce', 112, 0, '0', 'Akçaabat'),
(778, 1, 'ilce', 112, 0, '0', 'Araklı'),
(779, 1, 'ilce', 112, 0, '0', 'Arsin'),
(780, 1, 'ilce', 112, 0, '0', 'Beşikdüzü'),
(781, 1, 'ilce', 112, 0, '0', 'Çarşıbaşı'),
(782, 1, 'ilce', 112, 0, '0', 'Çaykara'),
(783, 1, 'ilce', 112, 0, '0', 'Dernekpazarı'),
(784, 1, 'ilce', 112, 0, '0', 'Düzköy'),
(785, 1, 'ilce', 112, 0, '0', 'Hayrat'),
(786, 1, 'ilce', 112, 0, '0', 'Köprübaşı'),
(787, 1, 'ilce', 112, 0, '0', 'Maçka'),
(788, 1, 'ilce', 112, 0, '0', 'Of'),
(789, 1, 'ilce', 112, 0, '0', 'Sürmene'),
(790, 1, 'ilce', 112, 0, '0', 'Şalpazarı'),
(791, 1, 'ilce', 112, 0, '0', 'Tonya'),
(792, 1, 'ilce', 112, 0, '0', 'Vakfıkebir'),
(793, 1, 'ilce', 112, 0, '0', 'Yomra'),
(794, 1, 'ilce', 113, 0, '0', 'Merkez'),
(795, 1, 'ilce', 113, 0, '0', 'Çemişgezek'),
(796, 1, 'ilce', 113, 0, '0', 'Hozat'),
(797, 1, 'ilce', 113, 0, '0', 'Mazgirt'),
(798, 1, 'ilce', 113, 0, '0', 'Nazımiye'),
(799, 1, 'ilce', 113, 0, '0', 'Ovacık'),
(800, 1, 'ilce', 113, 0, '0', 'Pertek'),
(801, 1, 'ilce', 113, 0, '0', 'Pülümür'),
(802, 1, 'ilce', 114, 0, '0', 'Merkez'),
(803, 1, 'ilce', 114, 0, '0', 'Akçakale'),
(804, 1, 'ilce', 114, 0, '0', 'Birecik'),
(805, 1, 'ilce', 114, 0, '0', 'Bozova'),
(806, 1, 'ilce', 114, 0, '0', 'Ceylanpınarı'),
(807, 1, 'ilce', 114, 0, '0', 'Halfeti'),
(808, 1, 'ilce', 114, 0, '0', 'Harran'),
(809, 1, 'ilce', 114, 0, '0', 'Hilvan'),
(810, 1, 'ilce', 114, 0, '0', 'Siverek'),
(811, 1, 'ilce', 114, 0, '0', 'Suruç'),
(812, 1, 'ilce', 114, 0, '0', 'Viranşehir'),
(813, 1, 'ilce', 115, 0, '0', 'Merkez'),
(814, 1, 'ilce', 115, 0, '0', 'Banaz'),
(815, 1, 'ilce', 115, 0, '0', 'Eşme'),
(816, 1, 'ilce', 115, 0, '0', 'Karahallı'),
(817, 1, 'ilce', 115, 0, '0', 'Sivaslı'),
(818, 1, 'ilce', 115, 0, '0', 'Ulubey'),
(819, 1, 'ilce', 116, 0, '0', 'Merkez'),
(820, 1, 'ilce', 116, 0, '0', 'Bahçesaray'),
(821, 1, 'ilce', 116, 0, '0', 'Başkale'),
(822, 1, 'ilce', 116, 0, '0', 'Çaldıran'),
(823, 1, 'ilce', 116, 0, '0', 'Çatak'),
(824, 1, 'ilce', 116, 0, '0', 'Edremit'),
(825, 1, 'ilce', 116, 0, '0', 'Erciş'),
(826, 1, 'ilce', 116, 0, '0', 'Gevaş'),
(827, 1, 'ilce', 116, 0, '0', 'Gürpınar'),
(828, 1, 'ilce', 116, 0, '0', 'Muradiye'),
(829, 1, 'ilce', 116, 0, '0', 'Özalp'),
(830, 1, 'ilce', 116, 0, '0', 'Saray'),
(831, 1, 'ilce', 117, 0, '0', 'Merkez'),
(832, 1, 'ilce', 117, 0, '0', 'Akdağmadeni'),
(833, 1, 'ilce', 117, 0, '0', 'Aydıncık'),
(834, 1, 'ilce', 117, 0, '0', 'Boğazlıyan'),
(835, 1, 'ilce', 117, 0, '0', 'Çandır'),
(836, 1, 'ilce', 117, 0, '0', 'Çayıralan'),
(837, 1, 'ilce', 117, 0, '0', 'Çekerek'),
(838, 1, 'ilce', 117, 0, '0', 'Kadışehri'),
(839, 1, 'ilce', 117, 0, '0', 'Saraykent'),
(840, 1, 'ilce', 117, 0, '0', 'Sarıkaya'),
(841, 1, 'ilce', 117, 0, '0', 'Sorgun'),
(842, 1, 'ilce', 117, 0, '0', 'Şefaatli'),
(843, 1, 'ilce', 117, 0, '0', 'Yenifakılı'),
(844, 1, 'ilce', 117, 0, '0', 'Yerköy'),
(845, 1, 'ilce', 118, 0, '0', 'Merkez'),
(846, 1, 'ilce', 118, 0, '0', 'Alaplı'),
(847, 1, 'ilce', 118, 0, '0', 'Çaycuma'),
(848, 1, 'ilce', 118, 0, '0', 'Devrek'),
(849, 1, 'ilce', 118, 0, '0', 'Ereğli'),
(850, 1, 'ilce', 118, 0, '0', 'Gökçebey'),
(851, 1, 'ilce', 119, 0, '0', 'Merkez'),
(852, 1, 'ilce', 119, 0, '0', 'Ağaçören'),
(853, 1, 'ilce', 119, 0, '0', 'Eskil'),
(854, 1, 'ilce', 119, 0, '0', 'Gülağaç'),
(855, 1, 'ilce', 119, 0, '0', 'Güzelyurt'),
(856, 1, 'ilce', 119, 0, '0', 'Ortaköy'),
(857, 1, 'ilce', 119, 0, '0', 'Sarıyahşi'),
(858, 1, 'ilce', 120, 0, '0', 'Merkez'),
(859, 1, 'ilce', 120, 0, '0', 'Aydıntepe'),
(860, 1, 'ilce', 120, 0, '0', 'Demirözü'),
(861, 1, 'ilce', 121, 0, '0', 'Merkez'),
(862, 1, 'ilce', 121, 0, '0', 'Ayrancı'),
(863, 1, 'ilce', 121, 0, '0', 'Başyayla'),
(864, 1, 'ilce', 121, 0, '0', 'Ermenek'),
(865, 1, 'ilce', 121, 0, '0', 'Kazımkarabekir'),
(866, 1, 'ilce', 121, 0, '0', 'Sarıveliler'),
(867, 1, 'ilce', 122, 0, '0', 'Merkez'),
(868, 1, 'ilce', 122, 0, '0', 'Bahşili'),
(869, 1, 'ilce', 122, 0, '0', 'Balışeyh'),
(870, 1, 'ilce', 122, 0, '0', 'Çelebi'),
(871, 1, 'ilce', 122, 0, '0', 'Delice'),
(872, 1, 'ilce', 122, 0, '0', 'Karakeçili'),
(873, 1, 'ilce', 122, 0, '0', 'Keskin'),
(874, 1, 'ilce', 122, 0, '0', 'Sulakyurt'),
(875, 1, 'ilce', 122, 0, '0', 'Yahşiyan'),
(876, 1, 'ilce', 123, 0, '0', 'Merkez'),
(877, 1, 'ilce', 123, 0, '0', 'Beşiri'),
(878, 1, 'ilce', 123, 0, '0', 'Gercüş'),
(879, 1, 'ilce', 123, 0, '0', 'Hasankeyf'),
(880, 1, 'ilce', 123, 0, '0', 'Kozluk'),
(881, 1, 'ilce', 123, 0, '0', 'Sason'),
(882, 1, 'ilce', 124, 0, '0', 'Merkez'),
(883, 1, 'ilce', 124, 0, '0', 'Beytüşşebap'),
(884, 1, 'ilce', 124, 0, '0', 'Cizre'),
(885, 1, 'ilce', 124, 0, '0', 'Güçlükonak'),
(886, 1, 'ilce', 124, 0, '0', 'İdil İlçesi'),
(887, 1, 'ilce', 124, 0, '0', 'Silopi'),
(888, 1, 'ilce', 124, 0, '0', 'Uludere'),
(889, 1, 'ilce', 125, 0, '0', 'Merkez'),
(890, 1, 'ilce', 125, 0, '0', 'Amasra'),
(891, 1, 'ilce', 125, 0, '0', 'Kurucasile'),
(892, 1, 'ilce', 125, 0, '0', 'Ulus'),
(893, 1, 'ilce', 126, 0, '0', 'Merkez'),
(894, 1, 'ilce', 126, 0, '0', 'Çıldır'),
(895, 1, 'ilce', 126, 0, '0', 'Damal'),
(896, 1, 'ilce', 126, 0, '0', 'Göle'),
(897, 1, 'ilce', 126, 0, '0', 'Hanak'),
(898, 1, 'ilce', 126, 0, '0', 'Posof'),
(899, 1, 'ilce', 127, 0, '0', 'Merkez'),
(900, 1, 'ilce', 127, 0, '0', 'Aralık'),
(901, 1, 'ilce', 127, 0, '0', 'Karakoyunlu'),
(902, 1, 'ilce', 127, 0, '0', 'Tuzluca'),
(903, 1, 'ilce', 128, 0, '0', 'Merkez'),
(904, 1, 'ilce', 128, 0, '0', 'Altınova'),
(905, 1, 'ilce', 128, 0, '0', 'Armutlu'),
(906, 1, 'ilce', 128, 0, '0', 'Çınarcık'),
(907, 1, 'ilce', 128, 0, '0', 'Çiftlikköy'),
(908, 1, 'ilce', 128, 0, '0', 'Termal'),
(909, 1, 'ilce', 129, 0, '0', 'Merkez'),
(910, 1, 'ilce', 129, 0, '0', 'Eflani'),
(911, 1, 'ilce', 129, 0, '0', 'Eskipazar'),
(912, 1, 'ilce', 129, 0, '0', 'Ovacık'),
(913, 1, 'ilce', 129, 0, '0', 'Safranbolu'),
(914, 1, 'ilce', 129, 0, '0', 'Yenice'),
(915, 1, 'ilce', 130, 0, '0', 'Merkez'),
(916, 1, 'ilce', 130, 0, '0', 'Elbeyli'),
(917, 1, 'ilce', 130, 0, '0', 'Musabeyli'),
(918, 1, 'ilce', 130, 0, '0', 'Polateli'),
(919, 1, 'ilce', 131, 0, '0', 'Merkez'),
(920, 1, 'ilce', 131, 0, '0', 'Akçakoca'),
(921, 1, 'ilce', 131, 0, '0', 'Cumayeri'),
(922, 1, 'ilce', 131, 0, '0', 'Çilimli'),
(923, 1, 'ilce', 131, 0, '0', 'Gölkaya'),
(924, 1, 'ilce', 131, 0, '0', 'Gümüşova'),
(925, 1, 'ilce', 131, 0, '0', 'Kaynaşlı'),
(926, 1, 'ilce', 131, 0, '0', 'Yığılca'),
(927, 1, 'ilce', 52, 0, '0', 'Merkez'),
(928, 1, 'ilce', 53, 0, '0', 'Merkez'),
(929, 1, 'ilce', 54, 0, '0', 'Merkez'),
(930, 1, 'ilce', 55, 0, '0', 'Merkez'),
(931, 1, 'ilce', 56, 0, '0', 'Merkez'),
(932, 1, 'ilce', 57, 0, '0', 'Merkez'),
(933, 1, 'ilce', 58, 0, '0', 'Merkez'),
(934, 1, 'ilce', 59, 0, '0', 'Merkez'),
(935, 1, 'ilce', 61, 0, '0', 'Merkez'),
(936, 1, 'ilce', 62, 0, '0', 'Merkez'),
(937, 1, 'ilce', 63, 0, '0', 'Merkez'),
(938, 1, 'ilce', 64, 0, '0', 'Merkez'),
(939, 1, 'ilce', 65, 0, '0', 'Merkez'),
(940, 1, 'ilce', 67, 0, '0', 'Merkez'),
(941, 1, 'ilce', 68, 0, '0', 'Merkez'),
(942, 1, 'ilce', 69, 0, '0', 'Merkez'),
(943, 1, 'ilce', 70, 0, '0', 'Merkez'),
(944, 1, 'ilce', 71, 0, '0', 'Merkez'),
(945, 1, 'ilce', 72, 0, '0', 'Merkez'),
(946, 1, 'ilce', 73, 0, '0', 'Merkez'),
(947, 1, 'ilce', 74, 0, '0', 'Merkez'),
(948, 1, 'ilce', 75, 0, '0', 'Merkez'),
(949, 1, 'ilce', 76, 0, '0', 'Merkez'),
(950, 1, 'ilce', 77, 0, '0', 'Merkez'),
(951, 1, 'ilce', 78, 0, '0', 'Merkez'),
(952, 1, 'ilce', 79, 0, '0', 'Merkez'),
(953, 1, 'ilce', 80, 0, '0', 'Merkez'),
(954, 1, 'ilce', 81, 0, '0', 'Merkez'),
(955, 1, 'ilce', 82, 0, '0', 'Merkez'),
(956, 1, 'ilce', 84, 0, '0', 'Merkez'),
(957, 1, 'ilce', 86, 0, '0', 'Merkez'),
(958, 1, 'ilce', 87, 0, '0', 'Merkez'),
(959, 1, 'ilce', 88, 0, '0', 'Merkez'),
(960, 1, 'ilce', 89, 0, '0', 'Merkez'),
(961, 1, 'ilce', 90, 0, '0', 'Merkez'),
(962, 1, 'ilce', 91, 0, '0', 'Merkez'),
(963, 1, 'ilce', 92, 0, '0', 'Merkez'),
(964, 1, 'ilce', 93, 0, '0', 'Merkez'),
(965, 1, 'ilce', 1153, 0, '0', 'Merkez'),
(966, 1, 'ilce', 1153, 0, '0', 'Bahçe'),
(967, 1, 'ilce', 1153, 0, '0', 'Düziçi'),
(968, 1, 'ilce', 1153, 0, '0', 'Hasanbeyli'),
(969, 1, 'ilce', 1153, 0, '0', 'Kadirli'),
(970, 1, 'ilce', 1153, 0, '0', 'Sumbas'),
(971, 1, 'ilce', 1153, 0, '0', 'Toprakkale'),
(972, 1, 'ilce', 96, 0, '0', 'Yunusemre');
";
		return $sqls;
	}
	//--------------------------------------------------------------------
}
