<?php namespace Pratik\Controllers;
use CodeIgniter\Controller;
use Pratik\Config\Ogrenciler_Config;
use Pratik\Models\Pratik_Model;
class Ogrenciler extends Controller
{
	public $data = array();
	public $model ;
	public $state=false ;
    function __construct()
	{
        $this->model = new Pratik_Model();
        $this->session = \Config\Services::session();
		$this->request = \Config\Services::request();
		$this->data['module'] = 'ogrenciler';	
    }
	public function index()
	{	
		if($this->state === false ) $this->state =  $this->request->getPostget('state');	
		if($this->state===null) $this->state=1;
		$elements = new Ogrenciler_Config();
		$this->data['page_title']=t_('ogrenciler','ucretsate_'.$this->state);		
		$this->data['elements'] = $elements->basic;	
		$this->data['state'] = $this->state;
		$this->data['menu'] =array('ogrenciler','ogrencisate_'.$this->state);		
		return view('Admin\ogrenciler\ogrenci_list', array('data'=>$this->data));
	}
	public function setup()
	{
		$elements = new Ogrenciler_Config();
		$this->model->setupTable('ogrenciler',$elements->basic);
		$this->model->setupTable('ogrenciler_gecmis',$elements->gecmis);
		$this->model->setupTable('hesaplar',$elements->hesaplar);
		$this->data['menu']=array('ogrenciler');
	}
	public function edit()
	{	
		$id =  $this->request->getPostget('id');
		$elements = new Ogrenciler_Config();
		//$model->setupTable('users',$elements->basic);
		$this->data['basic'] = $this->model->getBasic('ogrenciler', $id, $elements->basic,'',true );
		$this->data['gecmis'] = $this->model->getBasic('ogrenciler_gecmis', 0, $elements->gecmis,'',true );
		$this->data['hesaplar'] = $this->model->getBasic('ogrenciler_hesaplar', 0, $elements->hesaplar,'',true );
		$this->data['hesaplistesi'] = $this->model->getTableRows('ogrenciler_hesaplar', 'owner='.$id, 0, 0, 'tarih ASC' );
		$this->data['toplam_tahsilat'] = $this->model->getTableSum('ogrenciler_hesaplar', "owner=$id AND `tip`='T'", 'tutar');
		$this->data['toplam_alacak'] = $this->model->getTableSum('ogrenciler_hesaplar', "owner=$id AND `tip`='A'", 'tutar');

		//$this->data['toplam_alacak'] =
		$this->data['gecmisler'] = $this->model->getTableRows('ogrenciler_gecmis', 'owner='.$id, 0, 0, 'tarih ASC' );
		if(!$this->data['gecmisler']) $this->data['gecmisler']=array();
		foreach($this->data['gecmisler'] as $gkey => $gecmis)
		{
			$durum = '#';
			if($gecmis['durum']==0) $durum = 'Pasif';
			if($gecmis['durum']==1) $durum = 'Aktif Edildi';
			if($gecmis['durum']==2) $durum = 'Ara Verdi';
			$this->data['gecmisler'][$gkey]['durum'] = $durum;
		}
		if($id==0)
		{
			$this->data['basic']['id']['val']=0;
			$this->data['basic']['ad']['val']=t_('Yeni Öğrenci');
		}
		$this->data['metas'] = $this->model->getMetas($id, 'ogrenciler', "",$elements->metas, 'tr_TR', 'meta', true, false);
		$this->data['page_title']=t_('Ücretler');		
		$this->data['menu']=array('ogrenciler','ogrenci_edit');
		return view('Admin\ogrenciler\ogrenci_edit', array('data'=>$this->data));
	}
	public function gecmis()
	{	
		$id =  $this->request->getPostget('id');
		$gecmis =  $this->request->getGetpost('gecmis');
		$gecmis['owner'] = $id;
		$gecmis['tarih'] = date('Y-m-d H:i:s');
		$gecmis['user'] = UID();		
		$elements = new Ogrenciler_Config();
		$this->model->saveBasic('ogrenciler_gecmis', $gecmis, $elements->gecmis);
		$this->model->setTableValue('ogrenciler', $id, 'state', $gecmis['durum']);
		redirect2(getSubUrl('ogrenciler/edit?id=2',1));
	}
	public function odeme()
	{	
		$id =  $this->request->getPostget('id');
		$hesaplar =  $this->request->getGetpost('hesaplar');
		if($hesaplar)
		{
			$hesaplar['owner'] = $id;
			$hesaplar['user'] = UID();		
			$elements = new Ogrenciler_Config();


			$this->model->saveBasic('ogrenciler_hesaplar', $hesaplar, $elements->hesaplar);
		}
		
		redirect2(getSubUrl('ogrenciler/edit?id='.$id.'&tab=odeme',1));
	}
	
	public function delete()
	{	
		$id =  $this->request->getPostget('id');
		$this->state = 0;
		
		if(!$id)
		{
			addAlert('Code', t_('Geçersiz Kayıt Id!'), 'danger' );				
		} elseif($id==UID()){
			addAlert('Code', t_('Kendinizi Silemezsiniz!'), 'danger' );			
			$this->state = 1;
		} else {
			$this->model->setTableValue('users', $id, 'state', '0');
			addAlert('Code', t_('Kayıt Silindi!'), 'success' );		
		}
		return $this->index();
		
	}

	public function delete_hesap()
	{
		$id =  $this->request->getPostget('id');
		$hesap_id =  $this->request->getPostget('hesap_id');
		if($id && $hesap_id)
		{
			$this->model->deleteTableRow('ogrenciler_hesaplar',$hesap_id, 'owner='.(int)$id);
		}
		return $this->edit();
	}
	//--------------------------------------------------------------------
}
