<?php namespace Pratik\Controllers;

use CodeIgniter\Controller;
use Pratik\Models\Pratik_Model;

class Ajax extends Controller
{
	public $model;
	public $ajaxresult;

    function __construct()
	{

        $this->model = new Pratik_Model();
        $this->session = \Config\Services::session();
		$this->request = \Config\Services::request();
		$this->ajaxresult = array('refresh'=>0,
								   'redirect'=>0,
								   'id'=>'',
								   'state'=>'success',/* success, warning, info, danger */
								   'data'=>'',
								   'message'=>'İşlem Başlatılamadı.',
								   'html'=>'',
								  );
		if(!isset($_POST['formtoken']) || $this->session->get('formtoken')!=$this->request->getGetPost('formtoken'))
		{
			//echo json_encode($this->ajaxresult,true);
			//die();		
		}

    }
	public function getElements($module)
	{
		$classname = '\Pratik\Config\\'.ucfirst($module).'_Config';
		$elements =  new $classname();
		return $elements;
		
	}	
	public function saveBasic()
	{
		$data =  $this->request->getGetpost('basic');
		$module =  $this->request->getGetpost('module');
		$retval = '';
		$elements = $this->getElements($module);

		if($data)$retval = $this->model->saveBasic($module,$data,$elements->basic);

		if(isset($retval['error']) && $retval['error']['message']!='')
		{
			$this->ajaxresult['state'] = 'danger';
			$this->ajaxresult['message']=t_($retval['error']['message']);		
			
		} else {
			if(!$retval['id'])
			{
				$this->ajaxresult['state'] = 'warning';
				$this->ajaxresult['message']=t_($retval['error']['message']);

			} elseif($data['id'] != $retval['id']){

				//$this->ajaxresult['redirect']=getSubUrl('users?id='.$retval);
				$this->ajaxresult['message']=t_('Success').$module.$retval['id'];		
				addAlert('Code', t_('Kayıt işlemi tamamlandı'), 'success' );
			} else {
				$this->ajaxresult['message']=t_('Success');		
			}			
		}
		$this->ajaxresult['data']=$retval;
		echo json_encode($this->ajaxresult,true);
		die();		
	}
	public function saveMetas()
	{
		$data =  $this->request->getGetpost('meta');
		$id =  $this->request->getGetpost('id');
		$module =  $this->request->getGetpost('module');
		$retval = false;
		$elements = $this->getElements($module);
		if($data)
		{
			$retval = 	$this->model->saveMetas($id, $module ,$data, $elements->metas );		
			if($retval)
			{
				$this->ajaxresult['data']=$id;
				$this->ajaxresult['state'] = 'success';
				$this->ajaxresult['message']=t_('Success');

			} else {
				$this->ajaxresult['data']=0;
				$this->ajaxresult['state'] = 'warning';
				$this->ajaxresult['message']=t_('Kayıt işlemi başarısız');
			}
		} else {
			
				$this->ajaxresult['data']=0;
				$this->ajaxresult['state'] = 'danger';
				$this->ajaxresult['message']=t_('Kayıt formu boş');
		}


		echo json_encode($this->ajaxresult,true);
		die();		
	}
	//--------------------------------------------------------------------
	public function get_permissions()
	{
		$sender = $_GET['sender']??'0';
		$this->ajaxresult['html'] ='<option value="0" >Diğer</option>';
		$rows[] = array('id'=>'1','name'=>'Yönetici');
		$rows[] = array('id'=>'2','name'=>'Hoca');
		$rows[] = array('id'=>'3','name'=>'Asistan');
		foreach($rows as $row)
		{
			$selected=$row['id']==$sender?'selected':'';
			$this->ajaxresult['html'] .='<option value="'.$row['id'].'" '.$selected.' >'.$row['name'].'</option>';
		}
		$this->ajaxresult['message']	= '';
		echo json_encode($this->ajaxresult,true);
		die();		
	}
	public function get_parabirimleri()
	{
		$sender = $_GET['sender']??'0';
		$this->ajaxresult['html'] ='<option value="TRY" >TRY</option>';
		$rows[] = array('id'=>'USD','name'=>'USD');
		$rows[] = array('id'=>'EUR','name'=>'EUR');
		foreach($rows as $row)
		{
			$selected=$row['id']==$sender?'selected':'';
			$this->ajaxresult['html'] .='<option value="'.$row['id'].'" '.$selected.' >'.$row['name'].'</option>';
		}
		$this->ajaxresult['message']	= '';
		echo json_encode($this->ajaxresult,true);
		die();		
	}
	public function get_ucrettipleri()
	{

		$sender = $_GET['sender']??'0';
		$this->ajaxresult['html'] ='<option value="normal" >'.t_('normal').'</option>';
		$rows[] = array('id'=>'pratik','name'=>t_('pratik'));
		$rows[] = array('id'=>'ogrenci','name'=>t_('ogrenci'));
		$rows[] = array('id'=>'seminer','name'=>t_('seminer'));
		$rows[] = array('id'=>'ozel_1','name'=>t_('ozel_1'));
		$rows[] = array('id'=>'ozel_5','name'=>t_('ozel_5'));
		$rows[] = array('id'=>'ozel_10','name'=>t_('ozel_10'));
		$rows[] = array('id'=>'paket_3','name'=>t_('paket_3'));
		$rows[] = array('id'=>'paket_6','name'=>t_('paket_6'));
		$rows[] = array('id'=>'paket_9','name'=>t_('paket_9'));
		$rows[] = array('id'=>'ilkay','name'=>t_('ilkay'));
		$rows[] = array('id'=>'diger','name'=>t_('Diğer'));
		foreach($rows as $row)
		{
			$selected=$row['id']==$sender?'selected':'';
			$this->ajaxresult['html'] .='<option value="'.$row['id'].'" '.$selected.' >'.$row['name'].'</option>';
		}
		$this->ajaxresult['message']	= '';
		echo json_encode($this->ajaxresult,true);
		die();		
	}
	public function get_indirimtipleri()
	{

		$sender = $_GET['sender']??'0';
		$this->ajaxresult['html'] ='<option value="diger" >'.t_('diger').'</option>';
		$rows[] = array('id'=>'tam','name'=>t_('tam'));
		$rows[] = array('id'=>'ogrenci','name'=>t_('ogrenci'));
		$rows[] = array('id'=>'esli','name'=>t_('esli'));
		$rows[] = array('id'=>'arkadasli','name'=>t_('arkadasli'));
		$rows[] = array('id'=>'group','name'=>t_('group'));
		$rows[] = array('id'=>'yensinif','name'=>t_('yensinif'));

		foreach($rows as $row)
		{
			$selected=$row['id']==$sender?'selected':'';
			$this->ajaxresult['html'] .='<option value="'.$row['id'].'" '.$selected.' >'.$row['name'].'</option>';
		}
		$this->ajaxresult['message']	= '';
		echo json_encode($this->ajaxresult,true);
		die();		
	}
	public function get_items($table, $value='id', $text='name')
	{
		$sender = $_GET['sender']??'0';
		$this->ajaxresult['state']	= 'ok';
		$this->ajaxresult['html'] ='<option value="0" >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>';
		$rows = $this->model->getTableRows( $table, 'state=1' );
		if($rows)
		{
			foreach($rows as $row)
			{
				$selected=$row['id']==$sender?'selected':'';
				$this->ajaxresult['html'] .='<option value="'.$row[$value].'" '.$selected.' >'.$row[$text].'</option>';
			}
			
		} else {
				$this->ajaxresult['html'] .='<option value="" ></option>';		
		}

		$this->ajaxresult['message']	= '';
		echo json_encode($this->ajaxresult,true);
		die();
		
	}
	// GLOBAL FONKSİYONLAR
	
	public function get_okullar()
	{
		$this->get_items('okullar','id','ad');
	}
	public function get_siniflar()
	{
		$this->get_items('siniflar','id','ad');
	}
	public function get_hocalar()
	{
		$this->get_items('hocalar','id','ad');
	}
	public function get_ucretler()
	{
		$this->get_items('ucretler','id','ad');
	}
	public function get_derslikler()
	{
		$this->get_items('derslikler','id','ad');
	}
	public function get_indirimler()
	{
		$this->get_items('indirimler','id','ad');
	}
	public function get_ogrencigruplari()
	{
		$this->get_items('ogrencigruplari','id','ad');
	}
	public function get_cities()
	{
		$sender = $_GET['sender']??'0';
		$this->ajaxresult['state']	= 'ok';
		$this->ajaxresult['html'] ='<option value="0" >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>';
		$rows = $this->model->getTableRows( 'cities');
		foreach($rows as $row)
		{
			$selected=$row['id']==$sender?'selected':'';
			$this->ajaxresult['html'] .='<option value="'.$row['id'].'" '.$selected.' >'.$row['name'].'</option>';
		}
		$this->ajaxresult['message']	= '';
		echo json_encode($this->ajaxresult,true);
		die();
	}
	public function get_districts() //statik select doldurmak için
	{
		$sender = $_GET['sender']??'0';
		$city=  $this->model->getTableValue( 'districts', "id='".$sender."'",'parent');//$table, $where='', $keys='*', $limit=1
		$this->ajaxresult['state']	= 'ok';
		$this->ajaxresult['html'] ='<option value="0" >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>';
		$rows = $this->model->getTableRows( 'districts',"parent='".$city."'");
		if($rows)
		{
			foreach($rows as $row)
			{
				$selected=$row['id']==$sender?'selected':'';
				$this->ajaxresult['html'] .='<option value="'.$row['id'].'" '.$selected.' >'.$row['name'].'</option>';
			}			
		} else {
			
				$this->ajaxresult['html'] .='<option value="0"  ></option>';
		}

		$this->ajaxresult['message']	= $sender;
		echo json_encode($this->ajaxresult,true);
		die();
	}
	public function get_district() //dinamik select doldurmak için
	{
		$sender = $_GET['sender']??'0';
		$this->ajaxresult['state']	= 'ok';
		$this->ajaxresult['html'] ='<option value="0" >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>';
		$rows = $this->model->getTableRows( 'districts',"parent='".$sender."'");
		foreach($rows as $row)
		{
			$selected=$row['id']==$sender?'selected':'';
			$this->ajaxresult['html'] .='<option value="'.$row['id'].'" '.$selected.' >'.$row['name'].'</option>';
		}
		$this->ajaxresult['message']	= $sender;
		echo json_encode($this->ajaxresult,true);
		die();
	}
	
	// SEARCH FONKSİYONLERI
	
	public function search_items($table, $where='', $value='id', $text='name') //dinamik select doldurmak için
	{
		$sender = $_GET['sender']??false;
		if($sender)
		{
			$name = $this->model->getTableValue($table, "id=".(int)$sender, $keys=$text );
			echo '<option value="'.(int)$sender.'">'.$name.'</option>';
			die();
		}
		$page = $_GET['page']??'1';
		$start = $page-1;
		$result['total_count'] = $this->model->getTableRowsCount( $table, $where);
		$rows =$this->model->getTableRows( $table, $where, 30, $start*30);
		$result['items']=array();
		if($rows)
		{
			foreach($rows as $row )
			{
				$result['items'][]=array('id'=>$row[$value],'text'=>$row[$text]);
			}
			
		}
		echo json_encode($result);		
		die();
		
	}
	public function search_ogrenciler()
	{
		$q = $_GET['q']??'';
		$where = "ad LIKE '%".$q."%' OR soyad LIKE '%".$q."%'";
		$this->search_items('ogrenciler', $where, 'id', 'ad');
	}
	
	public function ucret_hesapla() //dinamik ücret hesaplama
	{
		$id = $_GET['id']??false;
		$ucretid = $_GET['ucret']??false;
		$indirimid = $_GET['indirim']??false;
		if($id!==false && $ucretid!==false )
		{
			$ucret = $this->model->getTableValue('ucretler', "id=".(int)$ucretid, $keys='ucret' );
			$indirim = $this->model->getTableValue('indirimler', "id=".(int)$indirimid, $keys='oran' );
			if($indirim)
			{
				$retval = $ucret - ($ucret*($indirim/100));			
			} else {
				$retval = $ucret;			
			}
			
		} else {
			$retval = $indirimid;
		}
		
		die($retval);
	}
	public function grupta_kimler_var() //dinamik ücret hesaplama
	{
		$id = $_GET['id']??false;
		$html = '<div class="panel-body"><ul class="media-list media-list-linked">';
		if($id)
		{
			$ogrenciler = $this->model->getTableRows('ogrenciler', "ogrenci_grubu=".(int)$id);
			if($ogrenciler)
			{ 
				foreach($ogrenciler as $ogrenci)
				{
					$html .= '<li class="media">
							<a href="'.getSubUrl('/ogrenciler/edit?id='.$ogrenci['id'],1).'" class="media-link">
								<div class="media-left">'.getImg($ogrenci['resim'],64,64,'img-circle img-md','id="img_'.$ogrenci['id'].'"').'</div>
								<div class="media-body">
									<div class="media-heading text-semibold">'.$ogrenci['ad'].' '.$ogrenci['soyad'].'</div>
									<span class="text-muted">'.$ogrenci['email'].'</span>
								</div>
							</a>
						</li>';
				}
			
			}else {
				$html .= 'Grupta Kimse Yok';
			}
		} else {
				$html .= 'Grup Seçilmemiş';		
		}
		$html .= '</ul></div>';
		echo $html;
		die();
	}
}
								


