<?php

namespace Pratik\Config;

use CodeIgniter\Config\BaseConfig;

class Ogrenciler_Config extends BaseConfig

{
	public $basic = array('id'=>array(
							'name' => 'id','dbtype' => 'varchar', 'type' => 'hidden', 'target' => '','label' => 'Id','lenght' => '11'),
						 'numara'=>array(
							'name' => 'numara','dbtype' => 'varchar', 'type' => 'text','label' => 'Öğrenci No', 'lenght' => '8', 'unique'=>1),
						 'ad'=>array(
							'name' => 'ad','dbtype' => 'varchar', 'type' => 'text','label' => 'Adı', 'lenght' => '64'),
						 'soyad'=>array(
							'name' => 'soyad','dbtype' => 'varchar', 'type' => 'text','label' => 'Soyadı', 'lenght' => '64'),
						 'cinsiyet'=>array(
							'name' => 'cinsiyet','dbtype' => 'varchar', 'type' => 'dataselect', 'label' => 'Cinsiyet', 'lenght' => '8', 'data'=>array('', 'Kadın', 'Erkek')),
						 'dogum_tarihi'=>array(
							'name' => 'dogum_tarihi','dbtype' => 'varchar', 'type' => 'date','label' => 'Doğum Tarihi', 'lenght' => '16'),
						 'email'=>array(
							'name' => 'email', 'dbtype' => 'varchar', 'type' => 'email','label' => 'E-posta', 'lenght' => '254'),
						 'cap_tel'=>array(
							'name' => 'cap_tel', 'dbtype' => 'varchar', 'type' => 'text','label' => 'Cep Telefonu', 'lenght' => '16'),
						 'kayit_tarihi'=>array(
							'name' => 'kayit_tarihi', 'dbtype' => 'varchar', 'type' => 'date','label' => 'Kayıt Tarihi', 'lenght' => '16'),
						 'sinif'=>array(
							'name' => 'sinif', 'dbtype' => 'int', 'type' => 'select', 'source'=>'siniflar', 'label' => 'Sınıfı', 'lenght' => '11'),
						 'okul'=>array(
							'name' => 'okul', 'dbtype' => 'int', 'type' => 'select', 'source'=>'okullar', 'label' => 'Okulu', 'lenght' => '11'),
						 'hoca'=>array(
							'name' => 'hoca', 'dbtype' => 'int', 'type' => 'select', 'source'=>'hocalar', 'label' => 'Öğretmeni', 'lenght' => '11'),
						 'grup'=>array(
							'name' => 'grup', 'dbtype' => 'varchar', 'type' => 'dataselect', 'label' => 'Grubu', 'lenght' => '64', 'multiple'=>true,'data'=>array('Düzenli Öğrenci', 'Asistan', 'Next', 'Özel Öğrenci', 'Okul dışı', 'Seminer Öğrencisi', 'Pratik Öğrencisi', 'Diğer') ),
						 'kurs_ucreti'=>array(
							'name' => 'kurs_ucreti', 'dbtype' => 'int', 'type' => 'select', 'source'=>'ucretler', 'label' => 'Ücreti', 'lenght' => '11', 'class'=>'ucret_hesapla' ),
						 'indirim_kategori'=>array(
							'name' => 'indirim_kategori','dbtype' => 'int', 'type' => 'select', 'source'=>'indirimler', 'label' => 'İndirim Kategorisi', 'lenght' => '11', 'class'=>'ucret_hesapla'),
						 'net_ucret'=>array(
							'name' => 'net_ucret', 'dbtype' => 'decimal', 'type' => 'text','label' => 'Net Ücret', 'attrib'=>'readonly', 'lenght' => '10,2'),
						 'ogrenci_grubu'=>array(
							'name' => 'ogrenci_grubu','dbtype' => 'int', 'type' => 'select', 'source'=>'ogrencigruplari', 'label' => 'Öğrenci Grubu', 'lenght' => '11', 'help'=>'<a id="grupta-kimler-var">Grupta kimler var?</a>'),
						 'esli_mi'=>array(
							'name' => 'esli_mi', 'dbtype' => 'int', 'type' => 'yesno','label' => 'Eşli mi?', 'lenght' => '1'),
						 'esi'=>array(
							'name' => 'esi', 'dbtype' => 'int', 'type' => 'search', 'source'=>'ogrenciler', 'label' => 'Eşi', 'lenght' => '11'),
						 'referans'=>array(
							'name' => 'referans','dbtype' => 'varchar', 'type' => 'dataselect', 'label' => 'Referans', 'lenght' => '8', 'data'=>array('Yok', 'İnternet','Facebook','Google','Arkadaş')),
						 'state'=>array(
							'name' => 'state','dbtype' => 'int', 'type' => 'dataselect' , 'indexed'=>1 ,'lenght' => '1','label' => 'Aktif mi?', 'data'=>array('1'=>'Evet','0'=>'Hayır')),
						  'resim'=>array(
							'name' => 'resim', 'dbtype' => 'varchar', 'type' => 'image', 'label' => 'User Image', 'lenght' => '255'),

						);

	public $metas = array();

	public $gecmis = array('id'=>array(
							'name' => 'id','dbtype' => 'varchar', 'type' => 'hidden', 'target' => '','label' => 'Id','lenght' => '11'),
						 'tarih'=>array(
							'name' => 'tarih','dbtype' => 'varchar', 'type' => 'hidden','label' => 'Tarih', 'lenght' => '16'),
						 'owner'=>array(
							'name' => 'owner','dbtype' => 'int', 'type' => 'hidden' , 'lenght' => '11','label' => 'Öğrenci Id'),
						 'user'=>array(
							'name' => 'user','dbtype' => 'varchar', 'type' => 'hidden' , 'lenght' => '64','label' => 'Kullanıcı'),
						 'aciklama'=>array(
							'name' => 'aciklama','dbtype' => 'varchar', 'type' => 'textarea' , 'lenght' => '255','label' => 'Açıklama'),
						 'durum'=>array(
							'name' => 'durum','dbtype' => 'int', 'type' => 'hidden' , 'lenght' => '1','label' => 'Durum'),
						  );
	public $hesaplar = array('id'=>array(
							'name' => 'id','dbtype' => 'varchar', 'type' => 'hidden', 'target' => '','label' => 'Id','lenght' => '11'),
						 'tarih'=>array(
							'name' => 'tarih','dbtype' => 'varchar', 'type' => 'date','label' => 'Tarih', 'lenght' => '16'),
						 'owner'=>array(
							'name' => 'owner','dbtype' => 'int', 'type' => 'hidden' , 'lenght' => '11','label' => 'Öğrenci Id'),
						 'user'=>array(
							'name' => 'user','dbtype' => 'varchar', 'type' => 'hidden' , 'lenght' => '64','label' => 'Kullanıcı'),
						 'tur'=>array(
							'name' => 'tur','dbtype' => 'varchar', 'type' => 'dataselect', 'lenght' => '32', 'label' => 'Türü', 'data'=>array('ozelders_ucreti'=>'Özel Ders Ücreti', 'kurs_ucreti'=>'Kurs Ücreti','pratik_ucreti'=>'Pratik Ücreti')),
						 'tip'=>array(
							'name' => 'tip','dbtype' => 'varchar', 'type' => 'dataselect', 'indexed'=>1 , 'lenght' => '1', 'label' => 'Tipi', 'data'=>array('A'=>'Gelir', 'B'=>'Gider')),
						 'tutar'=>array(
							'name' => 'tutar','dbtype' => 'int', 'type' => 'numeric' , 'lenght' => '11', 'label' => 'Tutar', 'numeric-max' => '9999', ),
						 'aciklama'=>array(
							'name' => 'aciklama','dbtype' => 'varchar', 'type' => 'textarea' , 'lenght' => '255','label' => 'Açıklama'),
						 'state'=>array(
							'name' => 'state','dbtype' => 'int', 'type' => 'none' , 'indexed'=>1 ,'lenght' => '1','label' => 'Aktif mi?', 'data'=>array('1'=>'Evet','0'=>'Hayır')),
						  );


}